/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.clustering.Clustering;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.util.MatrixUtils;

public class BKmeans
extends Clustering {
    protected ArrayList<ArrayList<Integer>> clusters;
    protected AbstractMatrix centroids;
    protected AbstractDissimilarity diss;
    protected static final float EPSILON = 1.0E-5f;
    protected int nrIterations = 15;

    public BKmeans(int nrclusters) {
        super(nrclusters);
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(AbstractDissimilarity diss, AbstractMatrix matrix) throws IOException {
        try {
            int i;
            long start = System.currentTimeMillis();
            this.diss = diss;
            this.clusters = new ArrayList();
            this.centroids = MatrixFactory.getInstance(matrix.getClass());
            ArrayList<Object> gCluster = new ArrayList<Integer>();
            int size1 = matrix.getRowCount();
            for (i = 0; i < size1; ++i) {
                gCluster.add(i);
            }
            this.clusters.add(gCluster);
            this.centroids.addRow((AbstractVector)matrix.getRow(0).clone());
            for (int j = 0; j < this.nrclusters - 1; ++j) {
                gCluster = this.getClusterToSplit(this.clusters);
                if (gCluster.size() <= 1) continue;
                this.splitCluster(matrix, diss, gCluster);
            }
            for (i = this.clusters.size() - 1; i >= 0; --i) {
                if (this.clusters.get(i).size() > 0) continue;
                this.clusters.remove(i);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The Bissection k-means algorithm is returning an empty cluster. Number of requested clusters : {0}", this.nrclusters);
            }
            int removed = 0;
            for (int i2 = this.clusters.size() - 1; i2 >= 0; --i2) {
                if (!this.clusters.get(i2).isEmpty()) continue;
                this.clusters.remove(i2);
                this.centroids.removeRow(i2);
                ++removed;
            }
            if (removed > 0) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The Bissection k-means algorithm is returning empty clusters. Removed: {0}", removed);
            }
            long finish = System.currentTimeMillis();
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Bisecting K-Means time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
            String tmp = "Clusters sizes: ";
            for (int i3 = 0; i3 < this.clusters.size(); ++i3) {
                tmp = tmp + this.clusters.get(i3).size() + " ";
            }
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, tmp.trim());
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(BKmeans.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.clusters;
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(DistanceMatrix dmat) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractMatrix getCentroids() {
        return this.centroids;
    }

    public int[] getMedoids(AbstractMatrix matrix) throws IOException {
        int[] m = new int[this.centroids.getRowCount()];
        for (int i = 0; i < m.length; ++i) {
            int point = -1;
            float distance = Float.MAX_VALUE;
            for (int j = 0; j < this.clusters.get(i).size(); ++j) {
                float distance2 = this.diss.calculate(this.centroids.getRow(i), matrix.getRow(this.clusters.get(i).get(j)));
                if (!(distance > distance2)) continue;
                point = this.clusters.get(i).get(j);
                distance = distance2;
            }
            m[i] = point;
        }
        return m;
    }

    protected ArrayList<Integer> getClusterToSplit(ArrayList<ArrayList<Integer>> clusters) {
        ArrayList<Integer> gCluster = clusters.get(0);
        for (int i = 0; i < clusters.size(); ++i) {
            if (clusters.get(i).size() <= gCluster.size()) continue;
            gCluster = clusters.get(i);
        }
        return gCluster;
    }

    protected void splitCluster(AbstractMatrix matrix, AbstractDissimilarity diss, ArrayList<Integer> gCluster) throws IOException {
        try {
            this.centroids.removeRow(this.clusters.indexOf(gCluster));
            this.clusters.remove(gCluster);
            int[] pivots = this.getPivots(matrix, diss, gCluster);
            ArrayList<Integer> cluster_1 = new ArrayList<Integer>();
            cluster_1.add(pivots[0]);
            AbstractVector centroid_1 = (AbstractVector)matrix.getRow(pivots[0]).clone();
            ArrayList<Integer> cluster_2 = new ArrayList<Integer>();
            cluster_2.add(pivots[1]);
            AbstractVector centroid_2 = (AbstractVector)matrix.getRow(pivots[1]).clone();
            int iterations = 0;
            do {
                centroid_1 = this.calculateMean(matrix, cluster_1);
                centroid_2 = this.calculateMean(matrix, cluster_2);
                cluster_1.clear();
                cluster_2.clear();
                int size = gCluster.size();
                for (int i = 0; i < size; ++i) {
                    float distCentr_2;
                    float distCentr_1 = diss.calculate(matrix.getRow(gCluster.get(i)), centroid_1);
                    if (distCentr_1 < (distCentr_2 = diss.calculate(matrix.getRow(gCluster.get(i)), centroid_2))) {
                        cluster_1.add(gCluster.get(i));
                        continue;
                    }
                    if (distCentr_2 < distCentr_1) {
                        cluster_2.add(gCluster.get(i));
                        continue;
                    }
                    if (cluster_1.size() > cluster_2.size()) {
                        cluster_2.add(gCluster.get(i));
                        continue;
                    }
                    cluster_1.add(gCluster.get(i));
                }
                if (cluster_1.size() < 1) {
                    cluster_1.add(cluster_2.get(0));
                    cluster_2.remove(cluster_2.get(0));
                    continue;
                }
                if (cluster_2.size() >= 1) continue;
                cluster_2.add(cluster_1.get(0));
                cluster_1.remove(cluster_1.get(0));
            } while (++iterations < this.nrIterations);
            this.clusters.add(cluster_1);
            this.clusters.add(cluster_2);
            this.centroids.addRow(centroid_1);
            this.centroids.addRow(centroid_2);
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(BKmeans.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected int[] getPivots(AbstractMatrix matrix, AbstractDissimilarity diss, ArrayList<Integer> gCluster) throws IOException {
        float distance;
        int aux;
        int el;
        int[] pivots = new int[2];
        ArrayList<Pivot> pivots_aux = new ArrayList<Pivot>();
        AbstractVector mean = this.calculateMean(matrix, gCluster);
        float size = 1 + gCluster.size() / 10;
        int i = 0;
        while ((float)i < size) {
            el = (int)((float)gCluster.size() / size * (float)i);
            aux = gCluster.get(el);
            distance = diss.calculate(mean, matrix.getRow(aux));
            pivots_aux.add(new Pivot(distance, aux));
            ++i;
        }
        Collections.sort(pivots_aux);
        pivots[0] = ((Pivot)pivots_aux.get((int)((int)((float)pivots_aux.size() * 0.75f)))).id;
        pivots_aux.clear();
        i = 0;
        while ((float)i < size) {
            el = (int)((float)gCluster.size() / size * (float)i);
            aux = gCluster.get(el);
            distance = diss.calculate(matrix.getRow(pivots[0]), matrix.getRow(aux));
            pivots_aux.add(new Pivot(distance, aux));
            ++i;
        }
        Collections.sort(pivots_aux);
        pivots[1] = ((Pivot)pivots_aux.get((int)((int)((float)pivots_aux.size() * 0.75f)))).id;
        return pivots;
    }

    protected AbstractVector calculateMean(AbstractMatrix matrix, ArrayList<Integer> cluster) throws IOException {
        AbstractMatrix mean = MatrixFactory.getInstance(matrix.getClass());
        int size = cluster.size();
        for (int i = 0; i < size; ++i) {
            mean.addRow(matrix.getRow(cluster.get(i)));
        }
        return MatrixUtils.mean(mean);
    }

    public class Pivot
    implements Comparable<Pivot> {
        public float distance;
        public int id;

        public Pivot(float distance, int id) {
            this.distance = distance;
            this.id = id;
        }

        @Override
        public int compareTo(Pivot o) {
            return Float.compare(this.distance, o.distance);
        }
    }
}

