/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.datamining.clustering.Clustering;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class BKmedoids
extends Clustering {
    private ArrayList<Integer> medoids;

    public BKmedoids(int nrclusters) {
        super(nrclusters);
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(AbstractDissimilarity diss, AbstractMatrix matrix) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.execute(dmat);
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(DistanceMatrix dmat) throws IOException {
        ArrayList<ArrayList<Integer>> clusters = new ArrayList<ArrayList<Integer>>();
        clusters.add(new ArrayList());
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            ((ArrayList)clusters.get(0)).add(i);
        }
        this.medoids = new ArrayList();
        this.medoids.add(0);
        for (int numberIterations = 0; numberIterations < this.nrclusters * 5 && clusters.size() < this.nrclusters; ++numberIterations) {
            int greatestCluster = 0;
            int greatestElements = clusters.get(0).size();
            for (int k = 1; k < clusters.size(); ++k) {
                if (clusters.get(k).size() <= greatestElements) continue;
                greatestCluster = k;
                greatestElements = clusters.get(k).size();
            }
            this.splitCluster(greatestCluster, clusters, dmat);
            this.eliminateEmptyClusters(clusters);
            int smallestCluster = 0;
            int smallestElements = clusters.get(0).size();
            for (int k = 1; k < clusters.size(); ++k) {
                if (clusters.get(k).size() >= smallestElements) continue;
                smallestCluster = k;
                smallestElements = clusters.get(k).size();
            }
            this.joinCluster(smallestCluster, clusters, dmat);
        }
        return clusters;
    }

    private void eliminateEmptyClusters(ArrayList<ArrayList<Integer>> clusters) {
        for (int i = 0; i < clusters.size(); ++i) {
            if (clusters.get(i).size() != 0) continue;
            clusters.remove(i);
            this.medoids.remove(i--);
        }
    }

    private void splitCluster(int cluster, ArrayList<ArrayList<Integer>> clusters, DistanceMatrix dmat) {
        ArrayList<Integer> oldCluster = clusters.get(cluster);
        clusters.remove(cluster);
        this.medoids.remove(cluster);
        int[] pivots = this.getPivots(oldCluster);
        ArrayList<Integer> cluster1 = new ArrayList<Integer>();
        int medoids1 = pivots[0];
        ArrayList<Integer> cluster2 = new ArrayList<Integer>();
        int medoids2 = pivots[1];
        for (int i = 0; i < oldCluster.size(); ++i) {
            float distanceCentroid2;
            float distanceCentroid1 = dmat.getDistance(oldCluster.get(i), medoids1);
            if (distanceCentroid1 < (distanceCentroid2 = dmat.getDistance(oldCluster.get(i), medoids2))) {
                cluster1.add(oldCluster.get(i));
                continue;
            }
            if (distanceCentroid1 > distanceCentroid2) {
                cluster2.add(oldCluster.get(i));
                continue;
            }
            if (cluster1.size() < cluster2.size()) {
                cluster1.add(oldCluster.get(i));
                continue;
            }
            cluster2.add(oldCluster.get(i));
        }
        clusters.add(cluster1);
        clusters.add(cluster2);
        this.medoids.add(medoids1);
        this.medoids.add(medoids2);
        this.updateMedoids(dmat, clusters);
    }

    private void updateMedoids(DistanceMatrix dmat, ArrayList<ArrayList<Integer>> clusters) {
        for (int cluster = 0; cluster < clusters.size(); ++cluster) {
            int medoid = clusters.get(cluster).get(0);
            float sumDistances = dmat.getMaxDistance();
            for (int point = 0; point < clusters.get(cluster).size(); ++point) {
                float sumDistances2 = 0.0f;
                for (int point2 = 0; point2 < clusters.get(cluster).size(); ++point2) {
                    sumDistances2 += dmat.getDistance(clusters.get(cluster).get(point), clusters.get(cluster).get(point2));
                }
                if (!(sumDistances > (sumDistances2 /= (float)clusters.get(cluster).size()))) continue;
                sumDistances = sumDistances2;
                medoid = clusters.get(cluster).get(point);
            }
            this.medoids.set(cluster, medoid);
        }
    }

    private void joinCluster(int cluster, ArrayList<ArrayList<Integer>> clusters, DistanceMatrix dmat) {
        if (clusters.get(cluster).size() < 5) {
            int j;
            int nearest = 0;
            float distance1 = dmat.getDistance(this.medoids.get(cluster), this.medoids.get(0));
            for (j = 0; j < clusters.size(); ++j) {
                float distance2;
                if (cluster == j || !(distance1 > (distance2 = dmat.getDistance(this.medoids.get(cluster), this.medoids.get(j))))) continue;
                distance1 = distance2;
                nearest = j;
            }
            for (j = 0; j < clusters.get(cluster).size(); ++j) {
                clusters.get(nearest).add(clusters.get(cluster).get(j));
            }
            clusters.remove(cluster);
            this.medoids.remove(cluster);
            this.updateMedoids(dmat, clusters);
        }
    }

    private int[] getPivots(ArrayList<Integer> cluster) {
        int[] pivots = new int[]{cluster.get(0), cluster.get(cluster.size() - 1)};
        return pivots;
    }

    public int[] getMedoids() {
        int[] c = new int[this.medoids.size()];
        for (int i = 0; i < this.medoids.size(); ++i) {
            c[i] = this.medoids.get(i);
        }
        return c;
    }

    @Override
    public AbstractMatrix getCentroids() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

