/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.datamining.clustering.Clustering;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class HierarchicalClustering
extends Clustering {
    private HierarchicalClusteringType type = HierarchicalClusteringType.CLINK;
    private ArrayList<ArrayList<Float>> distances = new ArrayList();

    public HierarchicalClustering(int nrclusters, HierarchicalClusteringType type) {
        super(nrclusters);
        this.type = type;
    }

    public HierarchicalClustering(HierarchicalClusteringType type) {
        super(0);
        this.type = type;
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(AbstractDissimilarity diss, AbstractMatrix matrix) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.execute(dmat);
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(DistanceMatrix dmat) throws IOException {
        this.init(dmat);
        ArrayList<ArrayList<Integer>> clusters = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < this.distances.size(); ++i) {
            clusters.add(new ArrayList());
            clusters.get(i).add(i);
        }
        while (clusters.size() > this.nrclusters) {
            int[] cmin = this.joinNearestClusters(clusters);
            this.updateDistanceMatrix(cmin);
        }
        return clusters;
    }

    public float[] getPointsHeight(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        this.init(dmat);
        ArrayList<ArrayList<Integer>> clusters = new ArrayList<ArrayList<Integer>>();
        float[] height = new float[this.distances.size()];
        for (int i = 0; i < this.distances.size(); ++i) {
            clusters.add(new ArrayList());
            clusters.get(i).add(i);
            height[i] = 0.0f;
        }
        while (clusters.size() > 1) {
            int[] cmin = this.joinNearestClusters(clusters);
            for (int i = 0; i < clusters.get(cmin[0]).size(); ++i) {
                int n = clusters.get(cmin[0]).get(i);
                height[n] = height[n] + 1.0f;
            }
            this.updateDistanceMatrix(cmin);
        }
        return height;
    }

    private void init(DistanceMatrix dmat) throws IOException {
        int i;
        for (i = 0; i < dmat.getElementCount(); ++i) {
            ArrayList<Float> lin = new ArrayList<Float>();
            for (int j = 0; j < dmat.getElementCount() - 1; ++j) {
                lin.add(Float.valueOf(0.0f));
            }
            this.distances.add(lin);
        }
        for (i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = 0; j < dmat.getElementCount(); ++j) {
                if (i == j) {
                    this.distances.get(i).add(j, Float.valueOf(0.0f));
                    continue;
                }
                float distance = dmat.getDistance(i, j);
                this.distances.get(i).set(j, Float.valueOf(distance));
                this.distances.get(j).set(i, Float.valueOf(distance));
            }
        }
    }

    private int[] joinNearestClusters(ArrayList<ArrayList<Integer>> clusters) {
        float minDistance = this.distances.get(0).get(1).floatValue();
        int[] cmin = new int[]{0, 1};
        for (int c1 = 0; c1 < clusters.size(); ++c1) {
            for (int c2 = c1 + 1; c2 < clusters.size(); ++c2) {
                if (!(minDistance > this.distances.get(c1).get(c2).floatValue())) continue;
                minDistance = this.distances.get(c1).get(c2).floatValue();
                cmin[0] = c1;
                cmin[1] = c2;
            }
        }
        for (int i = 0; i < clusters.get(cmin[1]).size(); ++i) {
            clusters.get(cmin[0]).add(clusters.get(cmin[1]).get(i));
        }
        clusters.remove(cmin[1]);
        return cmin;
    }

    private void updateDistanceMatrix(int[] cmin) {
        int i;
        if (this.type.equals((Object)HierarchicalClusteringType.SLINK)) {
            for (i = 0; i < this.distances.get(0).size(); ++i) {
                if (this.distances.get(cmin[0]).get(i).floatValue() < this.distances.get(cmin[1]).get(i).floatValue()) {
                    this.distances.get(cmin[0]).set(i, this.distances.get(cmin[0]).get(i));
                } else {
                    this.distances.get(cmin[0]).set(i, this.distances.get(cmin[1]).get(i));
                }
                if (this.distances.get(i).get(cmin[0]).floatValue() < this.distances.get(i).get(cmin[1]).floatValue()) {
                    this.distances.get(i).set(cmin[0], this.distances.get(i).get(cmin[0]));
                    continue;
                }
                this.distances.get(i).set(cmin[0], this.distances.get(i).get(cmin[1]));
            }
        } else if (this.type.equals((Object)HierarchicalClusteringType.CLINK)) {
            for (i = 0; i < this.distances.get(0).size(); ++i) {
                if (this.distances.get(cmin[0]).get(i).floatValue() > this.distances.get(cmin[1]).get(i).floatValue()) {
                    this.distances.get(cmin[0]).set(i, this.distances.get(cmin[0]).get(i));
                } else {
                    this.distances.get(cmin[0]).set(i, this.distances.get(cmin[1]).get(i));
                }
                if (this.distances.get(i).get(cmin[0]).floatValue() > this.distances.get(i).get(cmin[1]).floatValue()) {
                    this.distances.get(i).set(cmin[0], this.distances.get(i).get(cmin[0]));
                    continue;
                }
                this.distances.get(i).set(cmin[0], this.distances.get(i).get(cmin[1]));
            }
        } else if (this.type.equals((Object)HierarchicalClusteringType.ALINK)) {
            for (i = 0; i < this.distances.get(0).size(); ++i) {
                this.distances.get(cmin[0]).set(i, Float.valueOf((this.distances.get(cmin[0]).get(i).floatValue() * 2.0f + this.distances.get(cmin[1]).get(i).floatValue()) / 2.0f));
                this.distances.get(i).set(cmin[0], Float.valueOf((this.distances.get(i).get(cmin[0]).floatValue() * 2.0f + this.distances.get(i).get(cmin[1]).floatValue()) / 2.0f));
            }
        }
        this.distances.remove(cmin[1]);
        for (int k = 0; k < this.distances.size(); ++k) {
            this.distances.get(k).remove(cmin[1]);
        }
    }

    @Override
    public AbstractMatrix getCentroids() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum HierarchicalClusteringType {
        SLINK("Single link"),
        CLINK("Complete link"),
        ALINK("Average link");

        private final String name;

        private HierarchicalClusteringType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

