/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering.isodata;

public class SamplePoint {
    private int index;
    private float[] values;
    private int groupNumber;

    public SamplePoint(int index, float[] values) {
        this.index = index;
        this.values = values;
    }

    public int getDimension() {
        return this.getValues().length;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        if (this.index > 0) {
            sbuf.append("x").append(this.index).append(" (");
        } else {
            sbuf.append("values (");
        }
        for (int i = 0; i < this.getValues().length; ++i) {
            sbuf.append(this.getValues()[i]);
            if (i == this.getValues().length - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(")");
        return sbuf.toString();
    }

    public static float distance(SamplePoint dp1, SamplePoint dp2) {
        float result = 0.0f;
        float[] values1 = dp1.getValues();
        float[] values2 = dp2.getValues();
        for (int i = 0; i < values1.length; ++i) {
            float dis = values1[i] - values2[i];
            result += dis * dis;
        }
        return (float)Math.sqrt(result);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public float[] getValues() {
        return this.values;
    }

    public void setValues(float[] values) {
        this.values = values;
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public void setGroupNumber(int groupNumber) {
        this.groupNumber = groupNumber;
    }
}

