/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering.util;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.datamining.clustering.util.Pair;
import simpletree.datamining.dimreduction.DimWeightReduction;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;

public class CovarianceTopic {
    private final int numTerms;

    public CovarianceTopic(int numTerms) {
        this.numTerms = numTerms;
    }

    public ArrayList<Pair<String, Float>> getTerms(AbstractMatrix matrix, Cluster cluster) throws IOException {
        AbstractMatrix clusterMatrix = cluster.getClusterPointsMatrix(matrix);
        DimWeightReduction red = new DimWeightReduction(200);
        AbstractMatrix reducedMatrix = red.reduce(clusterMatrix, null);
        float[][] points = reducedMatrix.toMatrix();
        ArrayList<String> newAttributes = reducedMatrix.getAttributes();
        int size = points[0].length;
        int pivot1 = 0;
        int pivot2 = 0;
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                float cov;
                if (i == j || !(max < (cov = this.covariance(points, i, j)))) continue;
                max = cov;
                pivot1 = i;
                pivot2 = j;
            }
        }
        float covt1 = 0.0f;
        float covt2 = 0.0f;
        for (int i = 0; i < size; ++i) {
            covt1 += this.covariance(points, pivot1, i);
            covt2 += this.covariance(points, pivot2, i);
        }
        int pivot = covt1 > covt2 ? pivot1 : pivot2;
        System.out.println("PIVOT= " + newAttributes.get(pivot));
        DoubleMatrix2D covmat = this.createLaplacianMatrix(points);
        SingularValueDecomposition svd = new SingularValueDecomposition(covmat);
        double[] eignvect = svd.getU().viewColumn(points[0].length - 2).toArray();
        ArrayList<Pair<Integer, Float>> seq = new ArrayList<Pair<Integer, Float>>();
        for (int i = 0; i < eignvect.length; ++i) {
            float diff = (float)Math.abs(Math.abs(eignvect[pivot]) - Math.abs(eignvect[i]));
            seq.add(new Pair<Integer, Float>(i, Float.valueOf(1.0f / (1.0f + diff) * this.covariance(points, pivot, i))));
        }
        Collections.sort(seq, new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                float diff = ((Float)p2.second).floatValue() - ((Float)p1.second).floatValue();
                return diff == 0.0f ? 0 : (diff > 0.0f ? 1 : -1);
            }
        });
        ArrayList<Pair<String, Float>> terms = new ArrayList<Pair<String, Float>>();
        for (int i = 0; i < Math.min(this.numTerms, seq.size()); ++i) {
            if (!(((Float)((Pair)seq.get((int)i)).second).floatValue() >= ((Float)((Pair)seq.get((int)0)).second).floatValue() * 0.001f)) continue;
            Pair pair = new Pair(newAttributes.get((Integer)((Pair)seq.get((int)i)).first), ((Pair)seq.get((int)i)).second);
            terms.add(pair);
        }
        System.out.println("######");
        System.out.println("Number documents: " + points.length);
        for (Pair pair : terms) {
            System.out.print((String)pair.first + "<>" + pair.second + ";");
        }
        System.out.println();
        return terms;
    }

    private DoubleMatrix2D createLaplacianMatrix(float[][] points) {
        int j;
        int i;
        int size = points[0].length;
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(size, size);
        int nrneighbors = 10;
        for (i = 0; i < size; ++i) {
            ArrayList<Pair<Integer, Float>> covs = new ArrayList<Pair<Integer, Float>>();
            for (j = 0; j < size; ++j) {
                if (i == j) continue;
                float cov = this.covariance(points, i, j);
                covs.add(new Pair<Integer, Float>(j, Float.valueOf(cov)));
            }
            Collections.sort(covs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Pair p1 = (Pair)o1;
                    Pair p2 = (Pair)o2;
                    float diff = ((Float)p2.second).floatValue() - ((Float)p1.second).floatValue();
                    return diff == 0.0f ? 0 : (diff > 0.0f ? 1 : -1);
                }
            });
            for (j = 0; j < nrneighbors; ++j) {
                mat.setQuick(i, ((Integer)((Pair)covs.get((int)j)).first).intValue(), (double)((Float)((Pair)covs.get((int)j)).second).floatValue());
            }
        }
        this.fullconnect(points, mat);
        for (i = 0; i < size; ++i) {
            float diag = 0.0f;
            for (j = 0; j < size; ++j) {
                diag = (float)((double)diag + mat.getQuick(i, j));
            }
            mat.setQuick(i, i, (double)(-diag));
        }
        return mat;
    }

    private void fullconnect(float[][] points, DenseDoubleMatrix2D mat) {
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (int i = 0; i < mat.rows(); ++i) {
            indexes.add(i);
        }
        HashSet<Integer> removed = new HashSet<Integer>();
        this.fullconnect_aux(mat, 0, removed, indexes);
        while (!indexes.isEmpty()) {
            Iterator<Integer> it1 = indexes.iterator();
            int index1 = 0;
            int index2 = 0;
            float max = Float.NEGATIVE_INFINITY;
            while (it1.hasNext()) {
                int id1 = it1.next();
                for (int id2 : removed) {
                    float cov = this.covariance(points, id1, id2);
                    if (!(max < cov)) continue;
                    max = cov;
                    index1 = id1;
                    index2 = id2;
                }
            }
            mat.setQuick(index1, index2, (double)this.covariance(points, index1, index2));
            mat.setQuick(index2, index1, (double)this.covariance(points, index1, index2));
            this.fullconnect_aux(mat, index1, removed, indexes);
        }
    }

    private void fullconnect_aux(DenseDoubleMatrix2D mat, int toremove, HashSet<Integer> removed, HashSet<Integer> indexes) {
        boolean rem = indexes.remove(toremove);
        if (rem) {
            double[] array = mat.viewRow(toremove).toArray();
            for (int i = 0; i < array.length; ++i) {
                if (!(Math.abs(array[i]) > (double)1.0E-6f)) continue;
                removed.add(i);
                this.fullconnect_aux(mat, i, removed, indexes);
            }
        }
    }

    private float covariance(float[][] points, int a, int b) {
        float amean = 0.0f;
        float bmean = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            amean += points[i][a];
            bmean += points[i][b];
        }
        amean /= (float)points.length;
        bmean /= (float)points.length;
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += (points[i][a] - amean) * (points[i][b] - bmean);
        }
        return covariance /= (float)(points.length - 1);
    }

    public static void main(String[] args) throws IOException {
        Cluster clus = new Cluster(0);
        int[] i = new int[]{1340, 506, 374, 1204, 1248, 1200, 673, 1692, 706, 2475};
        ArrayList<Integer> itemList = new ArrayList<Integer>();
        for (int item : i) {
            itemList.add(item);
        }
        AbstractMatrix matrix = MatrixFactory.getInstance("/home/renato/AP_BBC_CNN_Reuters_nosource_nodate_novo.data");
        clus.setItemList(itemList);
        CovarianceTopic covTopic = new CovarianceTopic(30);
        covTopic.getTerms(matrix, clus);
    }
}

