/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.dimreduction;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;

public abstract class AbstractDimensionalityReduction {
    protected int targetDimension;

    public AbstractDimensionalityReduction(int targetDimension) {
        this.targetDimension = targetDimension;
    }

    public AbstractMatrix reduce(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        if (this.targetDimension < matrix.getDimensions()) {
            DenseMatrix redmatrix = new DenseMatrix();
            float[][] red = this.execute(matrix, diss);
            ArrayList<Integer> ids = matrix.getIds();
            float[] classData = matrix.getClassData();
            ArrayList<String> labels = matrix.getLabels();
            for (int i = 0; i < matrix.getRowCount(); ++i) {
                DenseVector dvector = new DenseVector(red[i], ids.get(i), classData[i]);
                if (labels.isEmpty()) {
                    ((AbstractMatrix)redmatrix).addRow(dvector);
                    continue;
                }
                redmatrix.addRow(dvector, labels.get(i));
            }
            ArrayList<String> attr = new ArrayList<String>();
            for (int i = 0; i < redmatrix.getDimensions(); ++i) {
                attr.add("attr");
            }
            redmatrix.setAttributes(attr);
            return redmatrix;
        }
        throw new IOException("The target dimension should be smaller than the dimension of the original points matrix.");
    }

    protected abstract float[][] execute(AbstractMatrix var1, AbstractDissimilarity var2) throws IOException;
}

