/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.dimreduction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import simpletree.datamining.clustering.util.Pair;
import simpletree.datamining.dimreduction.AbstractDimensionalityReduction;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;

public class DimWeightReduction
extends AbstractDimensionalityReduction {
    public DimWeightReduction(int targetDimension) {
        super(targetDimension);
    }

    @Override
    public AbstractMatrix reduce(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        DenseMatrix reducedMatrix = new DenseMatrix();
        ArrayList<Pair<Integer, Float>> pairs = new ArrayList<Pair<Integer, Float>>();
        float[][] points = matrix.toMatrix();
        for (int j = 0; j < points[0].length; ++j) {
            float freq = 0.0f;
            for (int i = 0; i < points.length; ++i) {
                freq += points[i][j];
            }
            pairs.add(new Pair<Integer, Float>(j, Float.valueOf(freq)));
        }
        Collections.sort(pairs, new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                float diff = ((Float)p2.second).floatValue() - ((Float)p1.second).floatValue();
                return diff == 0.0f ? 0 : (diff > 0.0f ? 1 : -1);
            }
        });
        float[][] newpoints = new float[points.length][];
        for (int i = 0; i < points.length; ++i) {
            newpoints[i] = new float[points[i].length < this.targetDimension ? points[i].length : this.targetDimension];
            for (int j = 0; j < newpoints[i].length; ++j) {
                newpoints[i][j] = points[i][(Integer)((Pair)pairs.get((int)j)).first];
            }
            AbstractVector originalRow = matrix.getRow(i);
            DenseVector denseRow = new DenseVector(newpoints[i], originalRow.getId(), originalRow.getKlass());
            ((AbstractMatrix)reducedMatrix).addRow(denseRow);
        }
        ArrayList<String> oldAttr = matrix.getAttributes();
        ArrayList<String> newAttr = new ArrayList<String>();
        for (int i = 0; i < newpoints[0].length; ++i) {
            newAttr.add(oldAttr.get((Integer)((Pair)pairs.get((int)i)).first));
        }
        reducedMatrix.setAttributes(newAttr);
        reducedMatrix.setLabels(matrix.getLabels());
        return reducedMatrix;
    }

    @Override
    protected float[][] execute(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

