/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.dimreduction;

import java.io.IOException;
import simpletree.datamining.dimreduction.AbstractDimensionalityReduction;
import simpletree.datamining.dimreduction.DimensionalityReductionFactory;
import simpletree.datamining.dimreduction.DimensionalityReductionParamView;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Transformation.Dimension Reduction", name="General Dimensionality Reduction", description="reduce the data dimensionality to a defined value smaller than the original dimensionality.")
public class DimensionalityReductionComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private DimensionalityReductionFactory.DimensionalityReductionType type = DimensionalityReductionFactory.DimensionalityReductionType.PCA;
    private int nrdimensions = 2;
    private transient DimensionalityReductionParamView paramview;
    private transient AbstractMatrix input;
    private transient AbstractMatrix output;

    public void execute() throws IOException {
        AbstractDimensionalityReduction red = DimensionalityReductionFactory.getInstance(this.type, this.nrdimensions);
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
        long init = System.currentTimeMillis();
        this.output = red.reduce(this.input, diss);
        long end = System.currentTimeMillis();
        long diff = end - init;
        System.out.println("Time spent (" + this.type.name() + ") -> " + (float)diff / 1000.0f + " seconds");
    }

    public void input(@Param(name="points matrix") AbstractMatrix input) {
        this.input = input;
    }

    public AbstractMatrix output() {
        return this.output;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new DimensionalityReductionParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.input = null;
        this.output = null;
    }

    public int getNumberDimensions() {
        return this.nrdimensions;
    }

    public void setNumberDimensions(int nrdimensions) {
        this.nrdimensions = nrdimensions;
    }

    public DimensionalityReductionFactory.DimensionalityReductionType getDimensionalityReductionType() {
        return this.type;
    }

    public void setDimensionalityReductionType(DimensionalityReductionFactory.DimensionalityReductionType type) {
        this.type = type;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType disstype) {
        this.disstype = disstype;
    }

    public int numberOriginalDimensions() {
        return this.input.getDimensions();
    }
}

