/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.dimreduction;

import java.io.IOException;
import simpletree.datamining.dimreduction.AbstractDimensionalityReduction;
import simpletree.datamining.dimreduction.DimWeightReduction;
import simpletree.datamining.dimreduction.FastmapReduction;
import simpletree.datamining.dimreduction.KMeansReduction;
import simpletree.datamining.dimreduction.PCAReduction;

public class DimensionalityReductionFactory {
    public static AbstractDimensionalityReduction getInstance(DimensionalityReductionType type, int target) throws IOException {
        AbstractDimensionalityReduction dr = null;
        if (type.equals((Object)DimensionalityReductionType.KMEANS)) {
            dr = new KMeansReduction(target);
        } else if (type.equals((Object)DimensionalityReductionType.PCA)) {
            dr = new PCAReduction(target);
        } else if (type.equals((Object)DimensionalityReductionType.FASTMAP)) {
            dr = new FastmapReduction(target);
        } else if (type.equals((Object)DimensionalityReductionType.WEIGHT)) {
            dr = new DimWeightReduction(target);
        }
        return dr;
    }

    public static enum DimensionalityReductionType {
        KMEANS("K-means"),
        PCA("Principal Components Analysis (PCA)"),
        FASTMAP("Fastmap"),
        WEIGHT("Most weighted columns");

        private final String name;

        private DimensionalityReductionType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

