/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.neighbors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.clustering.BKmeans;
import simpletree.datamining.neighbors.KNN;
import simpletree.datamining.neighbors.Pair;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class ANN {
    private int nrneighbors = 5;

    public ANN(int nrneighbors) {
        this.nrneighbors = nrneighbors;
    }

    public Pair[][] execute(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        BKmeans bkmeans = new BKmeans((int)Math.pow(matrix.getRowCount(), 0.75));
        ArrayList<ArrayList<Integer>> clusters = bkmeans.execute(diss, matrix);
        AbstractMatrix centroids = bkmeans.getCentroids();
        return this.execute(matrix, diss, clusters, centroids);
    }

    public Pair[][] execute(AbstractMatrix matrix, AbstractDissimilarity diss, ArrayList<ArrayList<Integer>> clusters, AbstractMatrix centroids) throws IOException {
        long start = System.currentTimeMillis();
        if ((int)Math.pow(this.nrneighbors, 0.625) > (int)Math.pow(matrix.getRowCount(), 0.5)) {
            throw new IOException("Too much neighbors, you should use KNN instead!");
        }
        Pair[][] neighbors = null;
        neighbors = new Pair[matrix.getRowCount()][];
        for (int i = 0; i < neighbors.length; ++i) {
            neighbors[i] = new Pair[this.nrneighbors];
            for (int j = 0; j < neighbors[i].length; ++j) {
                neighbors[i][j] = new Pair(-1, Float.MAX_VALUE);
            }
        }
        int nrClustersNeighbors = Math.max(5, (int)Math.sqrt((double)clusters.size() * Math.sqrt(this.nrneighbors)));
        nrClustersNeighbors = Math.min(nrClustersNeighbors * 2, clusters.size() - 1);
        DistanceMatrix dmat_clusters = new DistanceMatrix(centroids, diss);
        KNN clustersKNN = new KNN(nrClustersNeighbors);
        Pair[][] clustersNeighbors = clustersKNN.execute(dmat_clusters);
        dmat_clusters = null;
        centroids = null;
        System.gc();
        for (int c = 0; c < clusters.size(); ++c) {
            for (int e = 0; e < clusters.get(c).size(); ++e) {
                int cn;
                int el = clusters.get(c).get(e);
                for (int j = e + 1; j < clusters.get(c).size(); ++j) {
                    int other = clusters.get(c).get(j);
                    float dist = diss.calculate(matrix.getRow(el), matrix.getRow(other));
                    this.addDistance(neighbors[el], other, dist);
                    this.addDistance(neighbors[other], el, dist);
                }
                int nrtovisit = 1;
                int count = clusters.get(c).size() - 1;
                for (cn = 0; cn < clustersNeighbors[c].length && (count += clusters.get(clustersNeighbors[c][cn].index).size()) <= this.nrneighbors; ++cn) {
                    ++nrtovisit;
                }
                nrtovisit = nrtovisit > nrClustersNeighbors ? nrtovisit : nrClustersNeighbors;
                for (cn = 0; cn < nrtovisit; ++cn) {
                    int clneighbor = clustersNeighbors[c][cn].index;
                    for (int j = 0; j < clusters.get(clneighbor).size(); ++j) {
                        int other = clusters.get(clneighbor).get(j);
                        if (el == other) continue;
                        float dist = diss.calculate(matrix.getRow(el), matrix.getRow(other));
                        this.addDistance(neighbors[el], other, dist);
                    }
                }
            }
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Approximated KNN time: " + (float)(finish - start) / 1000.0f + "s");
        return neighbors;
    }

    public void addDistance(Pair[] neighbors, int index, float dist) {
        if (neighbors[neighbors.length - 1].value > dist) {
            neighbors[neighbors.length - 1].index = index;
            neighbors[neighbors.length - 1].value = dist;
            for (int k = neighbors.length - 2; k >= 0 && neighbors[k].value > dist; --k) {
                int tmp_index = neighbors[k].index;
                float tmp_value = neighbors[k].value;
                neighbors[k].index = index;
                neighbors[k].value = dist;
                neighbors[k + 1].index = tmp_index;
                neighbors[k + 1].value = tmp_value;
            }
        }
    }
}

