/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.normalization;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.normalization.AbstractNormalization;
import simpletree.datamining.normalization.NormalizationFactory;
import simpletree.datamining.normalization.NormalizationParamView;
import simpletree.matrix.AbstractMatrix;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Transformation", name="Normalization", description="Transform the data using a normalization process. It it is a Dense matrix, the original matrix will be modified.")
public class NormalizationComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient NormalizationParamView paramview;
    private NormalizationFactory.NormalizationType type = NormalizationFactory.NormalizationType.VECTORS_UNIT_LENGTH;
    private transient AbstractMatrix input;
    private transient AbstractMatrix output;

    public void execute() throws IOException {
        AbstractNormalization norm = NormalizationFactory.getInstance(this.type);
        this.output = norm.execute(this.input);
        this.output.setAttributes(this.input.getAttributes());
        this.output.setLabels(this.input.getLabels());
    }

    public void input(@Param(name="points matrix") AbstractMatrix input) {
        try {
            this.input = (AbstractMatrix)input.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(NormalizationComp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public AbstractMatrix output() {
        return this.output;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new NormalizationParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.input = null;
        this.output = null;
    }

    public NormalizationFactory.NormalizationType getNormalizationType() {
        return this.type;
    }

    public void setNormalizationType(NormalizationFactory.NormalizationType type) {
        this.type = type;
    }
}

