/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.normalization;

import simpletree.datamining.normalization.AbstractNormalization;
import simpletree.datamining.normalization.EqualizeColumns;
import simpletree.datamining.normalization.NormalizeColumns;
import simpletree.datamining.normalization.NormalizeRows;
import simpletree.datamining.normalization.Standardization;
import simpletree.datamining.normalization.ZScore;

public class NormalizationFactory {
    public static AbstractNormalization getInstance(NormalizationType type) {
        if (type.equals((Object)NormalizationType.STANDARDIZATION)) {
            return new Standardization();
        }
        if (type.equals((Object)NormalizationType.VECTORS_UNIT_LENGTH)) {
            return new NormalizeRows();
        }
        if (type.equals((Object)NormalizationType.NORMALIZE_COLUMNS)) {
            return new NormalizeColumns();
        }
        if (type.equals((Object)NormalizationType.EQUALIZATION)) {
            return new EqualizeColumns();
        }
        if (type.equals((Object)NormalizationType.ZSCORE)) {
            return new ZScore();
        }
        return null;
    }

    public static enum NormalizationType {
        STANDARDIZATION("Standardization colums"),
        VECTORS_UNIT_LENGTH("Vectors with unit lenght"),
        NORMALIZE_COLUMNS("Normalize colums"),
        EQUALIZATION("Equalization"),
        ZSCORE("Z Score");

        private final String name;

        private NormalizationType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

