/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.sampling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import simpletree.datamining.clustering.BKmeans;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.VectorFactory;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;

public class Sampling {
    private static final float EPSILON = 1.0E-7f;
    private SampleType sampletype;
    private int samplesize;

    public Sampling(SampleType sampletype, int samplesize) {
        this.sampletype = sampletype;
        this.samplesize = samplesize;
    }

    public AbstractMatrix execute(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        AbstractMatrix sampledata = null;
        if (this.sampletype == SampleType.CLUSTERING_MEDOID) {
            BKmeans bkmeans = new BKmeans(this.samplesize);
            bkmeans.execute(diss, matrix);
            int[] medoids = bkmeans.getMedoids(matrix);
            sampledata = MatrixFactory.getInstance(matrix.getClass());
            for (int i = 0; i < medoids.length; ++i) {
                if (matrix.getLabels().size() > 0) {
                    sampledata.addRow(matrix.getRow(medoids[i]), matrix.getLabel(medoids[i]));
                    continue;
                }
                sampledata.addRow(matrix.getRow(medoids[i]));
            }
        } else if (this.sampletype == SampleType.CLUSTERING_CENTROID) {
            BKmeans bkmeans = new BKmeans(this.samplesize);
            bkmeans.execute(diss, matrix);
            sampledata = bkmeans.getCentroids();
        } else if (this.sampletype == SampleType.MAXMIN) {
            Random random = new Random(System.currentTimeMillis());
            ArrayList<Integer> pivots = new ArrayList<Integer>();
            pivots.add(random.nextInt(matrix.getRowCount()));
            for (int i = 0; i < this.samplesize - 1; ++i) {
                float maxdist = Float.NEGATIVE_INFINITY;
                int maxpivot = 0;
                int size = matrix.getRowCount();
                for (int j = 0; j < size; ++j) {
                    float mindist = Float.POSITIVE_INFINITY;
                    int minpivot = 0;
                    for (int k = 0; k < pivots.size(); ++k) {
                        float dist = diss.calculate(matrix.getRow(j), matrix.getRow((Integer)pivots.get(k)));
                        if (!(mindist > dist)) continue;
                        mindist = dist;
                        minpivot = j;
                    }
                    if (!(maxdist < mindist)) continue;
                    maxdist = mindist;
                    maxpivot = minpivot;
                }
                pivots.add(maxpivot);
            }
            sampledata = MatrixFactory.getInstance(matrix.getClass());
            Iterator it = pivots.iterator();
            while (it.hasNext()) {
                int index = (Integer)it.next();
                AbstractVector row = matrix.getRow(index);
                if (matrix.getLabels().size() > 0) {
                    sampledata.addRow(VectorFactory.getInstance(matrix.getClass(), row.toArray(), row.getId(), row.getKlass()), matrix.getLabel(index));
                    continue;
                }
                sampledata.addRow(VectorFactory.getInstance(matrix.getClass(), row.toArray(), row.getId(), row.getKlass()));
            }
        } else if (this.sampletype == SampleType.SPAM) {
            float[] maxs = new float[matrix.getDimensions()];
            float[] mins = new float[matrix.getDimensions()];
            Arrays.fill(maxs, Float.NEGATIVE_INFINITY);
            Arrays.fill(mins, Float.POSITIVE_INFINITY);
            int size = matrix.getRowCount();
            for (int i = 0; i < size; ++i) {
                float[] array = matrix.getRow(i).toArray();
                for (int j = 0; j < array.length; ++j) {
                    if (maxs[j] < array[j]) {
                        maxs[j] = array[j];
                    }
                    if (!(mins[j] > array[j])) continue;
                    mins[j] = array[j];
                }
            }
            sampledata = new DenseMatrix();
            Random rand = new Random(System.currentTimeMillis());
            for (int i = 0; i < this.samplesize; ++i) {
                float[] vect = new float[matrix.getDimensions()];
                for (int j = 0; j < vect.length; ++j) {
                    vect[j] = rand.nextFloat() * (maxs[j] - mins[j]) + mins[j];
                }
                sampledata.addRow(new DenseVector(vect));
            }
        } else {
            sampledata = MatrixFactory.getInstance(matrix.getClass());
            HashSet<Integer> sample = new HashSet<Integer>();
            Random random = new Random(System.currentTimeMillis());
            int count = 0;
            while (sample.size() < this.samplesize && count < 2 * matrix.getRowCount()) {
                ++count;
                int index = random.nextInt(matrix.getRowCount());
                if (sample.contains(index)) continue;
                AbstractVector row = matrix.getRow(index);
                boolean similar = false;
                for (int i = 0; i < sampledata.getRowCount(); ++i) {
                    if (!this.similar(row, sampledata.getRow(i))) continue;
                    System.out.println("similar vectors...");
                    similar = true;
                    break;
                }
                if (similar) continue;
                sampledata.addRow(VectorFactory.getInstance(matrix.getClass(), row.toArray(), row.getId(), row.getKlass()));
                sample.add(index);
            }
        }
        return sampledata;
    }

    private boolean similar(AbstractVector v1, AbstractVector v2) {
        float[] values;
        float[] othervalues = v1.getValues();
        if (othervalues.length != (values = v2.getValues()).length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!(Math.abs(values[i] - othervalues[i]) > 1.0E-7f)) continue;
            return false;
        }
        return true;
    }

    public static enum SampleType {
        RANDOM("Random sampling"),
        CLUSTERING_CENTROID("Cluestring centroid sampling"),
        CLUSTERING_MEDOID("Cluestring medoid sampling"),
        MAXMIN("Max-min sampling"),
        SPAM("Spam");

        private final String name;

        private SampleType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

