/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.sampling;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.datamining.sampling.Sampling;
import simpletree.datamining.sampling.SamplingComp;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import vispipelinebasics.interfaces.AbstractParametersView;

public class SamplingParamView
extends AbstractParametersView {
    private SamplingComp comp;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JPanel improvementPanel;
    private JLabel nSamplesLabel;
    private JTextField nSamplesTextField;
    private JComboBox sampleComboBox;
    private JPanel samplePanel;

    public SamplingParamView(SamplingComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType dissimilarityType : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(dissimilarityType);
        }
        for (Enum enum_ : Sampling.SampleType.values()) {
            this.sampleComboBox.addItem(enum_);
        }
        this.reset();
    }

    private void initComponents() {
        this.improvementPanel = new JPanel();
        this.nSamplesLabel = new JLabel();
        this.nSamplesTextField = new JTextField();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.samplePanel = new JPanel();
        this.sampleComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.improvementPanel.setBorder(BorderFactory.createTitledBorder("Random Sampling"));
        this.improvementPanel.setLayout(new GridBagLayout());
        this.nSamplesLabel.setText("Number of samples");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nSamplesLabel, gridBagConstraints);
        this.nSamplesTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nSamplesTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add(this.improvementPanel, gridBagConstraints);
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.samplePanel.setBorder(BorderFactory.createTitledBorder("Sample"));
        this.samplePanel.setLayout(new BorderLayout());
        this.samplePanel.add((Component)this.sampleComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.samplePanel, gridBagConstraints);
    }

    public void reset() {
        this.nSamplesTextField.setText(Integer.toString(this.comp.getSampleSize()));
        this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        this.sampleComboBox.setSelectedItem((Object)this.comp.getSampleType());
    }

    public void finished() throws IOException {
        int ssize;
        if (this.nSamplesTextField.getText().trim().length() > 0) {
            ssize = Integer.parseInt(this.nSamplesTextField.getText());
            if (ssize <= 0) {
                throw new IOException("The sample size should be positive.");
            }
        } else {
            throw new IOException("The sample size should be provided.");
        }
        this.comp.setSampleSize(ssize);
        this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        this.comp.setSampleType((Sampling.SampleType)((Object)this.sampleComboBox.getSelectedItem()));
    }
}

