/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.test;

import java.io.IOException;
import simpletree.datamining.normalization.NormalizationComp;
import simpletree.datamining.normalization.NormalizationFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;

public class NormalizationTest {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("Usage: java -jar program.jar inputMatrix.data [s|v|c|e|z] outputMatrix.data");
            System.out.println("s: Standardization colums");
            System.out.println("v: Vectors with unit lenght");
            System.out.println("c: Normalize colums");
            System.out.println("e: Equalization");
            System.out.println("z: Z Score");
            System.exit(0);
        }
        AbstractMatrix inputMat = MatrixFactory.getInstance(args[0]);
        NormalizationComp normComp = new NormalizationComp();
        switch (args[1]) {
            case "s": {
                normComp.setNormalizationType(NormalizationFactory.NormalizationType.STANDARDIZATION);
                break;
            }
            case "v": {
                normComp.setNormalizationType(NormalizationFactory.NormalizationType.VECTORS_UNIT_LENGTH);
                break;
            }
            case "c": {
                normComp.setNormalizationType(NormalizationFactory.NormalizationType.NORMALIZE_COLUMNS);
                break;
            }
            case "e": {
                normComp.setNormalizationType(NormalizationFactory.NormalizationType.EQUALIZATION);
                break;
            }
            case "z": {
                normComp.setNormalizationType(NormalizationFactory.NormalizationType.ZSCORE);
            }
        }
        normComp.input(inputMat);
        normComp.execute();
        AbstractMatrix outputMat = normComp.output();
        outputMat.save(args[2]);
    }
}

