/*
 * Decompiled with CFR 0.152.
 */
package simpletree.disk;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import simpletree.disk.BinaryReaderComp;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.StreeFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class BinaryReaderParamView
extends AbstractParametersView {
    private transient BinaryReaderComp comp;
    private JTextField filenameTextField;
    private JLabel jLabel1;
    private JButton openButton;

    public BinaryReaderParamView(BinaryReaderComp comp) {
        this.initComponents();
        this.comp = comp;
        this.reset();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.filenameTextField = new JTextField();
        this.openButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("File name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add(this.jLabel1, gridBagConstraints);
        this.filenameTextField.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add(this.filenameTextField, gridBagConstraints);
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryReaderParamView.this.openButtonActionPerformed(evt);
            }
        });
        this.add(this.openButton, new GridBagConstraints());
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            int result = OpenDialog.showOpenDialog(spm, new StreeFilter(), (Component)((Object)this));
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.filenameTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(BinaryReaderParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void finished() throws IOException {
        this.comp.setFilename(this.filenameTextField.getText());
    }

    public void reset() {
        this.filenameTextField.setText(this.comp.getFilename());
    }
}

