/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import simpletree.detailedMatrix.dense.DetailedDenseMatrix;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class DetailedDistanceMatrix
extends DistanceMatrix {
    private String source = "";
    private String name = "";
    private AbstractDissimilarity diss;

    public DetailedDistanceMatrix(String filename) throws IOException {
        this.load(filename);
        this.source = filename;
        int begin = this.source.lastIndexOf("\\");
        int end = this.source.lastIndexOf(".");
        if (begin == -1) {
            begin = 0;
        } else if (begin + 1 <= end) {
            ++begin;
        }
        if (end == -1) {
            end = this.source.length();
        }
        this.name = this.source.substring(begin, end);
        if (!this.ids.isEmpty()) {
            int i;
            int id = (Integer)this.ids.get(0);
            boolean changed = false;
            for (i = 0; i < this.ids.size(); ++i) {
                if ((Integer)this.ids.get(i) == id) continue;
                changed = true;
                break;
            }
            if (!changed) {
                for (i = 0; i < this.ids.size(); ++i) {
                    this.ids.set(i, i);
                }
            }
        }
    }

    public DetailedDistanceMatrix(int nrElements) {
        super(nrElements);
    }

    public DetailedDistanceMatrix(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        super(matrix, diss);
        if (matrix instanceof DetailedDenseMatrix) {
            this.source = ((DetailedDenseMatrix)matrix).getSource() != null ? ((DetailedDenseMatrix)matrix).getSource() : matrix.toString();
        }
        int begin = this.source.lastIndexOf("\\");
        int end = this.source.lastIndexOf(".");
        if (begin == -1) {
            begin = 0;
        } else if (begin + 1 <= end) {
            ++begin;
        }
        if (end == -1) {
            end = this.source.length();
        }
        this.name = this.source.substring(begin, end);
        this.diss = diss;
    }

    public DetailedDistanceMatrix() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DetailedDistanceMatrix clonedmat = new DetailedDistanceMatrix(this.nrElements);
        clonedmat.maxDistance = this.maxDistance;
        clonedmat.minDistance = this.minDistance;
        for (int i = 0; i < this.distmatrix.length; ++i) {
            for (int j = 0; j < this.distmatrix[i].length; ++j) {
                clonedmat.distmatrix[i][j] = this.distmatrix[i][j];
            }
        }
        clonedmat.ids = new ArrayList();
        clonedmat.ids.addAll(this.ids);
        clonedmat.cdata = Arrays.copyOf(this.cdata, this.cdata.length);
        clonedmat.labels = new ArrayList();
        clonedmat.labels.addAll(this.labels);
        clonedmat.source = this.source;
        clonedmat.name = this.name;
        return clonedmat;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractDissimilarity getDiss() {
        return this.diss;
    }

    public void setDiss(AbstractDissimilarity diss) {
        this.diss = diss;
    }
}

