/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.util.Util;

public class DistanceMatrix
implements Cloneable {
    protected ArrayList<Integer> ids;
    protected ArrayList<String> labels;
    protected float[] cdata;
    protected float[][] distmatrix;
    protected int nrElements;
    protected float maxDistance;
    public int[] maxDistanceIndices = new int[2];
    protected float minDistance;
    public int[] minDistanceIndices = new int[2];

    public DistanceMatrix(String filename) throws IOException {
        this.load(filename);
    }

    public DistanceMatrix(int nrElements) {
        int i;
        this.maxDistance = Float.NEGATIVE_INFINITY;
        this.minDistance = Float.POSITIVE_INFINITY;
        this.nrElements = nrElements;
        this.distmatrix = new float[nrElements - 1][];
        for (i = 0; i < this.nrElements - 1; ++i) {
            this.distmatrix[i] = new float[i + 1];
        }
        this.ids = new ArrayList();
        this.labels = new ArrayList();
        for (i = 0; i < nrElements; ++i) {
            this.ids.add(i);
            this.labels.add(Integer.toString(i));
        }
        this.cdata = new float[nrElements];
        Arrays.fill(this.cdata, 0.0f);
    }

    public DistanceMatrix(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        this.nrElements = matrix.getRowCount();
        this.maxDistance = Float.NEGATIVE_INFINITY;
        this.minDistance = Float.POSITIVE_INFINITY;
        this.distmatrix = new float[this.nrElements - 1][];
        for (int i = 0; i < this.nrElements - 1; ++i) {
            this.distmatrix[i] = new float[i + 1];
            for (int j = 0; j < this.distmatrix[i].length; ++j) {
                float distance = diss.calculate(matrix.getRow(i + 1), matrix.getRow(j));
                this.setDistance(i + 1, j, distance);
            }
        }
        this.labels = matrix.getLabels();
        this.ids = matrix.getIds();
        this.cdata = matrix.getClassData();
    }

    public DistanceMatrix() {
        this.ids = new ArrayList();
        this.labels = new ArrayList();
    }

    public float[][] getDistmatrix() {
        return this.distmatrix;
    }

    public void setDistmatrix(float[][] distmatrix) {
        this.distmatrix = distmatrix;
    }

    public float getDistance(int indexA, int indexB) {
        assert (indexA >= 0 && indexA < this.nrElements && indexB >= 0 && indexB < this.nrElements) : "ERROR: index out of bounds!";
        if (indexA == indexB) {
            return 0.0f;
        }
        if (indexA < indexB) {
            return this.distmatrix[indexB - 1][indexA];
        }
        return this.distmatrix[indexA - 1][indexB];
    }

    public void setDistance(int indexA, int indexB, float value) {
        assert (indexA >= 0 && indexA < this.nrElements && indexB >= 0 && indexB < this.nrElements) : "ERROR: index out of bounds!";
        if (indexA != indexB) {
            if (indexA < indexB) {
                this.distmatrix[indexB - 1][indexA] = value;
            } else {
                this.distmatrix[indexA - 1][indexB] = value;
            }
            if (this.minDistance > value && value >= 0.0f) {
                this.minDistance = value;
                this.minDistanceIndices[0] = indexA;
                this.minDistanceIndices[1] = indexB;
            }
            if (this.maxDistance < value && value >= 0.0f) {
                this.maxDistance = value;
                this.maxDistanceIndices[0] = indexA;
                this.maxDistanceIndices[1] = indexB;
            }
        }
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public int getElementCount() {
        return this.nrElements;
    }

    public void setElementCount(int n) {
        this.nrElements = n;
    }

    public Object clone() throws CloneNotSupportedException {
        DistanceMatrix clonedmat = new DistanceMatrix(this.nrElements);
        clonedmat.maxDistance = this.maxDistance;
        clonedmat.minDistance = this.minDistance;
        for (int i = 0; i < this.distmatrix.length; ++i) {
            for (int j = 0; j < this.distmatrix[i].length; ++j) {
                clonedmat.distmatrix[i][j] = this.distmatrix[i][j];
            }
        }
        clonedmat.ids = new ArrayList();
        clonedmat.ids.addAll(this.ids);
        clonedmat.cdata = Arrays.copyOf(this.cdata, this.cdata.length);
        clonedmat.labels = new ArrayList();
        clonedmat.labels.addAll(this.labels);
        return clonedmat;
    }

    public void save(String filename) throws IOException {
        BufferedWriter out = null;
        try {
            int i;
            out = new BufferedWriter(new FileWriter(filename));
            out.write(Integer.toString(this.nrElements));
            out.write("\r\n");
            if (this.labels.size() > 0) {
                for (i = 0; i < this.labels.size() - 1; ++i) {
                    out.write(this.labels.get(i));
                    out.write(";");
                }
                out.write(this.labels.get(this.labels.size() - 1));
                out.write("\r\n");
            } else if (this.ids.size() > 0) {
                for (i = 0; i < this.ids.size() - 1; ++i) {
                    out.write(this.ids.get(i).toString());
                    out.write(";");
                }
                out.write(this.ids.get(this.ids.size() - 1).toString());
                out.write("\r\n");
            } else {
                for (i = 0; i < this.nrElements - 1; ++i) {
                    out.write(Integer.toString(i) + ";");
                }
                out.write(Integer.toString(this.nrElements - 1) + "\r\n");
            }
            if (this.cdata != null) {
                for (i = 0; i < this.cdata.length - 1; ++i) {
                    out.write(Float.toString(this.cdata[i]));
                    out.write(";");
                }
                out.write(Float.toString(this.cdata[this.cdata.length - 1]));
                out.write("\r\n");
            } else {
                for (i = 0; i < this.nrElements - 1; ++i) {
                    out.write("0;");
                }
                out.write("0\r\n");
            }
            for (i = 0; i < this.distmatrix.length; ++i) {
                for (int j = 0; j < this.distmatrix[i].length; ++j) {
                    out.write(Float.toString(this.distmatrix[i][j]));
                    if (j >= this.distmatrix[i].length - 1) continue;
                    out.write(";");
                }
                out.write("\r\n");
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void load(String filename) throws IOException {
        BufferedReader in = null;
        try {
            int i;
            in = new BufferedReader(new FileReader(filename));
            this.nrElements = Integer.parseInt(in.readLine());
            StringTokenizer tUrls = new StringTokenizer(in.readLine(), ";");
            this.ids = new ArrayList();
            this.labels = new ArrayList();
            int elementIndex = 0;
            while (tUrls.hasMoreTokens()) {
                String id = tUrls.nextToken().trim();
                if (Util.isParsableToInt(id)) {
                    this.ids.add(Integer.parseInt(id));
                } else {
                    this.ids.add(elementIndex++);
                }
                this.labels.add(id);
            }
            if (this.ids.size() != this.nrElements) {
                throw new IOException("The number of ids does not match with the size of matrix (" + this.ids.size() + " - " + this.nrElements + ").");
            }
            StringTokenizer tCdata = new StringTokenizer(in.readLine(), ";");
            ArrayList<Float> cdata_aux = new ArrayList<Float>();
            while (tCdata.hasMoreTokens()) {
                String token = tCdata.nextToken();
                cdata_aux.add(Float.valueOf(Float.parseFloat(token.trim())));
            }
            if (this.ids.size() != cdata_aux.size()) {
                throw new IOException("The number of class data items does not match with the size of matrix (" + this.ids.size() + " - " + this.nrElements + ").");
            }
            this.cdata = new float[cdata_aux.size()];
            for (i = 0; i < this.cdata.length; ++i) {
                this.cdata[i] = ((Float)cdata_aux.get(i)).floatValue();
            }
            this.maxDistance = Float.NEGATIVE_INFINITY;
            this.minDistance = Float.POSITIVE_INFINITY;
            this.distmatrix = new float[this.nrElements - 1][];
            for (i = 0; i < this.distmatrix.length; ++i) {
                this.distmatrix[i] = new float[i + 1];
            }
            for (i = 0; i < this.distmatrix.length; ++i) {
                String line = in.readLine();
                if (line != null) {
                    StringTokenizer tDistance = new StringTokenizer(line, ";");
                    for (int j = 0; j < this.distmatrix[i].length; ++j) {
                        if (!tDistance.hasMoreTokens()) {
                            throw new IOException("Wrong distance matrix file format.");
                        }
                        String token = tDistance.nextToken();
                        float dist = Float.parseFloat(token.trim());
                        this.setDistance(i + 1, j, dist);
                    }
                    continue;
                }
                throw new IOException("Wrong distance matrix file format.");
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DistanceMatrix.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public float[] getClassData() {
        return this.cdata;
    }

    public ArrayList<Integer> getIds() {
        return this.ids;
    }

    public void setClassData(float[] cdata) {
        this.cdata = cdata;
    }

    public void setIds(ArrayList<Integer> ids) {
        this.ids = ids;
        if (this.labels.isEmpty()) {
            for (Integer i : ids) {
                this.labels.add(i.toString());
            }
        }
    }

    public void setLabels(ArrayList<String> labels) {
        this.labels = labels;
    }

    public ArrayList<String> getLabels() {
        return this.labels;
    }

    public void removeElement(int id) {
        int index = this.ids.indexOf(id);
        if (index != -1) {
            int i;
            int col;
            int row;
            float[][] ndistmatrix = new float[this.distmatrix.length - 1][];
            for (int i2 = 0; i2 < ndistmatrix.length; ++i2) {
                ndistmatrix[i2] = new float[i2 + 1];
            }
            for (row = 0; row < index - 1; ++row) {
                for (col = 0; col < this.distmatrix[row].length; ++col) {
                    ndistmatrix[row][col] = this.distmatrix[row][col];
                }
                for (col = index + 1; col < this.distmatrix[row].length; ++col) {
                    ndistmatrix[row - 1][col - 1] = this.distmatrix[row][col];
                }
            }
            for (row = index; row < this.distmatrix.length; ++row) {
                for (col = 0; col < index; ++col) {
                    ndistmatrix[row - 1][col] = this.distmatrix[row][col];
                }
                for (col = index + 1; col < this.distmatrix[row].length; ++col) {
                    ndistmatrix[row - 1][col - 1] = this.distmatrix[row][col];
                }
            }
            this.distmatrix = ndistmatrix;
            --this.nrElements;
            this.ids.remove(index);
            this.labels.remove(index);
            float[] ncdata = new float[this.cdata.length - 1];
            for (i = 0; i < index; ++i) {
                ncdata[i] = this.cdata[i];
            }
            for (i = index + 1; i < this.cdata.length; ++i) {
                ncdata[i - 1] = this.cdata[i];
            }
            this.cdata = ncdata;
            this.maxDistance = Float.MIN_VALUE;
            this.minDistance = Float.MAX_VALUE;
            for (int row2 = 0; row2 < this.distmatrix.length; ++row2) {
                for (int col2 = 0; col2 < this.distmatrix[row2].length; ++col2) {
                    if (this.distmatrix[row2][col2] < this.minDistance) {
                        this.minDistance = this.distmatrix[row2][col2];
                        this.minDistanceIndices[0] = row2 + 1;
                        this.minDistanceIndices[1] = col2;
                    }
                    if (!(this.distmatrix[row2][col2] > this.maxDistance)) continue;
                    this.maxDistance = this.distmatrix[row2][col2];
                    this.maxDistanceIndices[0] = row2 + 1;
                    this.maxDistanceIndices[1] = col2;
                }
            }
        }
    }
}

