/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class LightWeightDistanceMatrix
extends DistanceMatrix {
    private AbstractMatrix matrix;
    private AbstractDissimilarity diss;

    public LightWeightDistanceMatrix(AbstractMatrix matrix, AbstractDissimilarity diss) {
        this.matrix = matrix;
        this.diss = diss;
        this.ids = new ArrayList();
        this.cdata = new float[matrix.getRowCount()];
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            this.ids.add(matrix.getRow(i).getId());
            this.cdata[i] = matrix.getRow(i).getKlass();
        }
        this.distmatrix = null;
        this.nrElements = matrix.getRowCount();
        this.labels = matrix.getLabels();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float getDistance(int indexA, int indexB) {
        assert (indexA >= 0 && indexA < this.nrElements && indexB >= 0 && indexB < this.nrElements) : "ERROR: index out of bounds!";
        return this.diss.calculate(this.matrix.getRow(indexA), this.matrix.getRow(indexB));
    }

    @Override
    public float getMaxDistance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float getMinDistance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void load(String filename) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void save(String filename) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClassData(float[] cdata) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDistance(int indexA, int indexB, float value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIds(ArrayList<Integer> ids) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

