/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.converter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.converter.DistanceMatrixCalculatorComp;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.util.SaveDialog;
import simpletree.util.filter.DMATFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class DistanceMatrixCalculatorParamView
extends AbstractParametersView {
    private DistanceMatrixCalculatorComp comp;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JCheckBox jCheckBox1;
    private JCheckBox saveDmatCheckBox;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JTextField titleTextField;

    public DistanceMatrixCalculatorParamView(DistanceMatrixCalculatorComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType type : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(type);
        }
        this.jCheckBox1.setSelected(comp.isNormalize());
        this.saveDmatCheckBox.setSelected(comp.getSaveDmat());
        this.reset();
    }

    private void initComponents() {
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.saveDmatCheckBox = new JCheckBox();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.jCheckBox1 = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Distance Matrix Calculator Parameters"));
        this.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.saveDmatCheckBox.setLabel("Save Distance Matrix");
        this.saveDmatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceMatrixCalculatorParamView.this.saveDmatCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add(this.saveDmatCheckBox, gridBagConstraints);
        this.titleLabel.setText("Label :");
        this.titlePanel.add(this.titleLabel);
        this.titleTextField.setColumns(15);
        this.titlePanel.add(this.titleTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add(this.titlePanel, gridBagConstraints);
        this.jCheckBox1.setText("Normalize");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceMatrixCalculatorParamView.this.jCheckBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.add(this.jCheckBox1, gridBagConstraints);
    }

    private void saveDmatCheckBoxActionPerformed(ActionEvent evt) {
        if (this.saveDmatCheckBox.isSelected()) {
            int result = SaveDialog.showSaveDialog(new DMATFilter(), (Component)((Object)this), "", "");
            if (result == 0) {
                this.comp.setDmatFilename(SaveDialog.getFilename());
                this.dissimilarityComboBox.setEnabled(true);
            } else {
                this.saveDmatCheckBox.setSelected(false);
                this.dissimilarityComboBox.setEnabled(false);
            }
        } else {
            this.comp.setDmatFilename("");
            this.dissimilarityComboBox.setEnabled(false);
        }
        this.comp.setSaveDmat(this.saveDmatCheckBox.isSelected());
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
    }

    public void reset() {
        this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        this.titleTextField.setText(this.comp.getTitle());
    }

    public void finished() throws IOException {
        this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        this.comp.setTitle(this.titleTextField.getText().trim());
        this.comp.setNormalize(this.jCheckBox1.isSelected());
    }
}

