/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.dissimilarity;

import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.CityBlock;
import simpletree.distance.dissimilarity.CosineBased;
import simpletree.distance.dissimilarity.DynamicTimeWarping;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.distance.dissimilarity.ExtendedJaccard;
import simpletree.distance.dissimilarity.HistogLog;
import simpletree.distance.dissimilarity.InfinityNorm;
import simpletree.distance.dissimilarity.MaxMovingEuclidean;
import simpletree.distance.dissimilarity.MinMovingEuclidean;

public class DissimilarityFactory {
    public static AbstractDissimilarity getInstance(DissimilarityType type) {
        if (type.equals((Object)DissimilarityType.CITY_BLOCK)) {
            return new CityBlock();
        }
        if (type.equals((Object)DissimilarityType.COSINE_BASED)) {
            return new CosineBased();
        }
        if (type.equals((Object)DissimilarityType.EUCLIDEAN)) {
            return new Euclidean();
        }
        if (type == DissimilarityType.HISTOGLOG) {
            return new HistogLog();
        }
        if (type.equals((Object)DissimilarityType.EXTENDED_JACCARD)) {
            return new ExtendedJaccard();
        }
        if (type.equals((Object)DissimilarityType.INFINITY_NORM)) {
            return new InfinityNorm();
        }
        if (type.equals((Object)DissimilarityType.DYNAMIC_TIME_WARPING)) {
            return new DynamicTimeWarping();
        }
        if (type.equals((Object)DissimilarityType.MAX_MOVING_EUCLIDEAN)) {
            return new MaxMovingEuclidean();
        }
        if (type.equals((Object)DissimilarityType.MIN_MOVING_EUCLIDEAN)) {
            return new MinMovingEuclidean();
        }
        return null;
    }

    public static enum DissimilarityType {
        CITY_BLOCK("City-block"),
        COSINE_BASED("Cosine-based dissimilarity"),
        EUCLIDEAN("Euclidean"),
        HISTOGLOG("Histogram Log"),
        EXTENDED_JACCARD("Extended Jaccard"),
        INFINITY_NORM("Infinity norm"),
        DYNAMIC_TIME_WARPING("Dynamic Time Warping (DTW)"),
        MAX_MOVING_EUCLIDEAN("Max Moving Euclidean"),
        MIN_MOVING_EUCLIDEAN("Min Moving Euclidean");

        private final String name;

        private DissimilarityType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

