/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.histogram;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.distance.histogram.DistanceHistogram;
import simpletree.distance.histogram.DistanceHistogramParamView;
import simpletree.matrix.AbstractMatrix;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Distance.View", name="Distance Histogram", description="Create a distance histogram.")
public class DistanceHistogramComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private String histogramLabel = "";
    private transient DistanceHistogramParamView paramview;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;

    public void execute() throws IOException {
        DistanceHistogram dh = new DistanceHistogram();
        if (this.matrix != null) {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            dh.display(new DistanceMatrix(this.matrix, diss), this.histogramLabel);
        } else if (this.dmat != null) {
            dh.display(this.dmat, this.histogramLabel);
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="distance matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new DistanceHistogramParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.matrix = null;
        this.dmat = null;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public boolean isDistanceMatrixProvided() {
        return this.dmat != null;
    }

    public void setHistogramLabel(String text) {
        this.histogramLabel = text;
    }

    public String getHistogramLabel() {
        return this.histogramLabel;
    }
}

