/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.similaritymatrix;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import simpletree.basics.color.ColorScalePanel;
import simpletree.coordination.IdentityCoordinator;
import simpletree.distance.DistanceMatrixReaderComp;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.distance.similaritymatrix.SimilarityMatrixFrameComp;
import simpletree.distance.similaritymatrix.SimilarityMatrixInstance;
import simpletree.distance.similaritymatrix.SimilarityMatrixModel;
import simpletree.distance.similaritymatrix.SimilarityMatrixModelComp;
import simpletree.model.AbstractInstance;

public class SimilarityMatrixFrame
extends JFrame
implements Observer {
    private SimilarityMatrixPanel view = new SimilarityMatrixPanel();
    private SimilarityMatrixModel model;
    private IdentityCoordinator coordinator;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel colorScalePanel;
    private JPanel similarityMatrixPanel;
    private JScrollPane similarityScrollPane;
    private JToolBar toolBar;
    private JButton zoomInButton;
    private JButton zoomOutButton;

    public SimilarityMatrixFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.toolBar = new JToolBar();
        this.zoomInButton = new JButton();
        this.zoomOutButton = new JButton();
        this.similarityMatrixPanel = new JPanel();
        this.similarityScrollPane = new JScrollPane(this.view);
        this.colorScalePanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Similarity Matrix View");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarityMatrixFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.toolBar.setRollover(true);
        this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        this.zoomInButton.setToolTipText("Zoom in");
        this.zoomInButton.setFocusable(false);
        this.zoomInButton.setHorizontalTextPosition(0);
        this.zoomInButton.setMaximumSize(new Dimension(29, 27));
        this.zoomInButton.setMinimumSize(new Dimension(29, 27));
        this.zoomInButton.setPreferredSize(new Dimension(29, 27));
        this.zoomInButton.setVerticalTextPosition(3);
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarityMatrixFrame.this.zoomInButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.zoomInButton);
        this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        this.zoomOutButton.setToolTipText("Zoom out");
        this.zoomOutButton.setFocusable(false);
        this.zoomOutButton.setHorizontalTextPosition(0);
        this.zoomOutButton.setMaximumSize(new Dimension(29, 27));
        this.zoomOutButton.setMinimumSize(new Dimension(29, 27));
        this.zoomOutButton.setPreferredSize(new Dimension(29, 27));
        this.zoomOutButton.setVerticalTextPosition(3);
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarityMatrixFrame.this.zoomOutButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.zoomOutButton);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.similarityMatrixPanel.setBorder(BorderFactory.createEtchedBorder());
        this.similarityMatrixPanel.setLayout(new BorderLayout());
        this.similarityScrollPane.setBorder(null);
        this.similarityMatrixPanel.add((Component)this.similarityScrollPane, "Center");
        this.colorScalePanel.setLayout(new FlowLayout(0));
        this.similarityMatrixPanel.add((Component)this.colorScalePanel, "North");
        this.getContentPane().add((Component)this.similarityMatrixPanel, "Center");
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void zoomInButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.zoomIn();
        }
    }

    private void zoomOutButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.zoomOut();
        }
    }

    public void display(SimilarityMatrixModel model) {
        this.model = model;
        model.addObserver(this);
        this.view.setPreferredSize(new Dimension(model.getSize().width, model.getSize().height));
        this.view.setSize(new Dimension(model.getSize().width, model.getSize().height));
        ColorScalePanel csp = new ColorScalePanel(null);
        csp.setColorTable(model.getColorTable());
        csp.setPreferredSize(new Dimension(200, 12));
        csp.setBackground(Color.WHITE);
        this.colorScalePanel.add(csp);
        this.colorScalePanel.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(600, 630));
        this.setSize(new Dimension(600, 630));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.model != null) {
            this.view.repaint();
        }
    }

    public IdentityCoordinator getCoordinator() {
        return this.coordinator;
    }

    public void setCoordinator(IdentityCoordinator coordinator) {
        this.coordinator = coordinator;
        if (coordinator != null) {
            coordinator.addModel(this.model);
        }
    }

    public static void main(String[] args) {
        try {
            DistanceMatrixReaderComp dmrc = new DistanceMatrixReaderComp();
            dmrc.setFilename("D:/My Dropbox/artigos/Chu/PexSensor/dados/eletrodopuro-imag.data-CAPACITANCE.data.dmat");
            dmrc.execute();
            SimilarityMatrixModelComp smmc = new SimilarityMatrixModelComp();
            smmc.input(dmrc.output());
            smmc.setDissimilarityType(DissimilarityFactory.DissimilarityType.COSINE_BASED);
            smmc.execute();
            SimilarityMatrixModel model = smmc.output();
            SimilarityMatrixFrameComp smfc = new SimilarityMatrixFrameComp();
            smfc.input(model);
            smfc.execute();
        }
        catch (IOException ex) {
            Logger.getLogger(SimilarityMatrixFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    class SimilarityMatrixPanel
    extends JPanel {
        private Point source;
        private Point target;
        private Color color = Color.RED;
        private String label;
        private Point labelpos;

        public SimilarityMatrixPanel() {
            this.setBackground(Color.WHITE);
            this.addMouseMotionListener(new MouseMotionListener());
            this.addMouseListener(new MouseClickedListener());
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            SimilarityMatrixFrame.this.model.draw((Graphics2D)g);
            Graphics2D g2 = (Graphics2D)g;
            if (this.source != null && this.target != null) {
                int x = Math.min(this.source.x, this.target.x);
                int width = Math.abs(this.target.x - this.source.x);
                int y = Math.min(this.source.y, this.target.y);
                int height = Math.abs(this.target.y - this.source.y);
                g2.setColor(this.color);
                g2.drawRect(x, y, width, height);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.setPaint(this.color);
                g2.fill(new Rectangle(x, y, width, height));
            } else if (this.label != null && this.labelpos != null) {
                g2.setFont(this.getFont());
                FontMetrics metrics = g2.getFontMetrics(g2.getFont());
                int width = metrics.stringWidth(this.label);
                int height = metrics.getAscent();
                g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
                g2.setPaint(Color.WHITE);
                g2.fill(new Rectangle(this.labelpos.x - 2, this.labelpos.y - height, width + 4, height + 4));
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                g2.setColor(Color.DARK_GRAY);
                g2.drawRect(this.labelpos.x - 2, this.labelpos.y - height, width + 4, height + 4);
                g2.drawString(this.label, this.labelpos.x, this.labelpos.y);
            }
        }

        public void zoomIn() {
            if (SimilarityMatrixFrame.this.model != null) {
                SimilarityMatrixFrame.this.model.setZoomFactor(SimilarityMatrixFrame.this.model.getZoomFactor() * 1.1f);
                this.setPreferredSize(new Dimension(((SimilarityMatrixFrame)SimilarityMatrixFrame.this).model.getSize().width, ((SimilarityMatrixFrame)SimilarityMatrixFrame.this).model.getSize().height));
                this.setSize(new Dimension(((SimilarityMatrixFrame)SimilarityMatrixFrame.this).model.getSize().width, ((SimilarityMatrixFrame)SimilarityMatrixFrame.this).model.getSize().height));
                SimilarityMatrixFrame.this.model.notifyObservers();
            }
        }

        public void zoomOut() {
            if (SimilarityMatrixFrame.this.model != null) {
                SimilarityMatrixFrame.this.model.setZoomFactor(SimilarityMatrixFrame.this.model.getZoomFactor() * 0.9091f);
                this.setPreferredSize(new Dimension(((SimilarityMatrixFrame)SimilarityMatrixFrame.this).model.getSize().width, ((SimilarityMatrixFrame)SimilarityMatrixFrame.this).model.getSize().height));
                this.setSize(new Dimension(((SimilarityMatrixFrame)SimilarityMatrixFrame.this).model.getSize().width, ((SimilarityMatrixFrame)SimilarityMatrixFrame.this).model.getSize().height));
                SimilarityMatrixFrame.this.model.notifyObservers();
            }
        }

        class MouseClickedListener
        extends MouseAdapter {
            MouseClickedListener() {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                super.mouseClicked(evt);
                if (SimilarityMatrixFrame.this.model != null) {
                    if (evt.getButton() == 3) {
                        SimilarityMatrixFrame.this.model.cleanSelectedInstances();
                    } else {
                        ArrayList<SimilarityMatrixInstance> instances = SimilarityMatrixFrame.this.model.getInstancesByPosition(evt.getPoint());
                        SimilarityMatrixFrame.this.model.setSelectedInstances(new ArrayList<AbstractInstance>(instances));
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                super.mousePressed(evt);
                if (evt.getButton() == 1 && SimilarityMatrixFrame.this.model != null) {
                    SimilarityMatrixPanel.this.source = evt.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                super.mouseReleased(evt);
                if (SimilarityMatrixFrame.this.model != null && SimilarityMatrixPanel.this.source != null && SimilarityMatrixPanel.this.target != null) {
                    Rectangle rect = new Rectangle();
                    rect.x = Math.min(((SimilarityMatrixPanel)SimilarityMatrixPanel.this).source.x, ((SimilarityMatrixPanel)SimilarityMatrixPanel.this).target.x);
                    rect.y = Math.min(((SimilarityMatrixPanel)SimilarityMatrixPanel.this).source.y, ((SimilarityMatrixPanel)SimilarityMatrixPanel.this).target.y);
                    rect.width = Math.abs(((SimilarityMatrixPanel)SimilarityMatrixPanel.this).source.x - ((SimilarityMatrixPanel)SimilarityMatrixPanel.this).target.x);
                    rect.height = Math.abs(((SimilarityMatrixPanel)SimilarityMatrixPanel.this).source.y - ((SimilarityMatrixPanel)SimilarityMatrixPanel.this).target.y);
                    ArrayList<SimilarityMatrixInstance> instances = SimilarityMatrixFrame.this.model.getInstancesByPosition(rect);
                    SimilarityMatrixFrame.this.model.setSelectedInstances(new ArrayList<AbstractInstance>(instances));
                    if (SimilarityMatrixFrame.this.coordinator != null) {
                        SimilarityMatrixFrame.this.coordinator.coordinate(new ArrayList<AbstractInstance>(instances), null);
                    }
                }
                SimilarityMatrixPanel.this.source = null;
                SimilarityMatrixPanel.this.target = null;
                SimilarityMatrixPanel.this.repaint();
            }
        }

        class MouseMotionListener
        extends MouseMotionAdapter {
            MouseMotionListener() {
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                super.mouseMoved(evt);
                if (SimilarityMatrixFrame.this.model != null) {
                    ArrayList<SimilarityMatrixInstance> instances = SimilarityMatrixFrame.this.model.getInstancesByPosition(evt.getPoint());
                    if (instances.size() > 0) {
                        SimilarityMatrixPanel.this.label = "";
                        for (int i = 0; i < instances.size(); ++i) {
                            SimilarityMatrixPanel.this.label = SimilarityMatrixPanel.this.label + instances.get(i).toString();
                            if (i >= instances.size() - 1) continue;
                            SimilarityMatrixPanel.this.label = SimilarityMatrixPanel.this.label + " <> ";
                        }
                        if (SimilarityMatrixPanel.this.label.trim().length() > 0) {
                            if (SimilarityMatrixPanel.this.label.length() > 100) {
                                SimilarityMatrixPanel.this.label = SimilarityMatrixPanel.this.label.substring(0, 96) + "...";
                            }
                            SimilarityMatrixPanel.this.labelpos = evt.getPoint();
                            SimilarityMatrixPanel.this.repaint();
                        }
                    } else {
                        SimilarityMatrixPanel.this.label = null;
                        SimilarityMatrixPanel.this.labelpos = null;
                        SimilarityMatrixPanel.this.repaint();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                if (SimilarityMatrixPanel.this.source != null) {
                    SimilarityMatrixPanel.this.target = evt.getPoint();
                }
                SimilarityMatrixPanel.this.repaint();
            }
        }
    }
}

