/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.similaritymatrix;

import java.awt.image.BufferedImage;
import simpletree.basics.color.ColorTable;
import simpletree.distance.similaritymatrix.SimilarityMatrixModel;
import simpletree.model.AbstractInstance;

public class SimilarityMatrixInstance
extends AbstractInstance {
    private String label;
    private float[] distances;
    private int position;
    private float cdata;

    public SimilarityMatrixInstance(SimilarityMatrixModel model, String label, int id, int position, float cdata) {
        super(id);
        this.setModel(model);
        model.addInstance(this);
        this.label = label;
        this.position = position;
        this.cdata = cdata;
    }

    public void draw(BufferedImage image, int border) {
        SimilarityMatrixModel smmodel = (SimilarityMatrixModel)this.model;
        for (int i = 0; i < this.distances.length; ++i) {
            float colorvalue = 0.0f;
            if (smmodel.getMaxDistance() > smmodel.getMinDistance()) {
                colorvalue = (this.distances[i] - smmodel.getMinDistance()) / (smmodel.getMaxDistance() - smmodel.getMinDistance());
            }
            ColorTable colortable = smmodel.getColorTable();
            ColorTable selcolortable = smmodel.getSelectionColorTable();
            if (this.selected) {
                image.setRGB(border + this.position, i, selcolortable.getColor(colorvalue).getRGB());
                image.setRGB(border + i, this.position, selcolortable.getColor(colorvalue).getRGB());
                continue;
            }
            image.setRGB(border + this.position, i, colortable.getColor(1.0f - colorvalue).getRGB());
            image.setRGB(border + i, this.position, colortable.getColor(1.0f - colorvalue).getRGB());
        }
    }

    public void setDistancesToInstances(float[] distances) {
        this.distances = distances;
        SimilarityMatrixModel smmodel = (SimilarityMatrixModel)this.model;
        float max = smmodel.getMaxDistance();
        float min = smmodel.getMinDistance();
        for (int i = 0; i < distances.length; ++i) {
            if (max < distances[i]) {
                max = distances[i];
            }
            if (!(min > distances[i])) continue;
            min = distances[i];
        }
        smmodel.setMaxDistance(max);
        smmodel.setMinDistance(min);
    }

    public float getClassData() {
        return this.cdata;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return this.label;
    }
}

