/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.similaritymatrix;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.basics.color.ColorScaleFactory;
import simpletree.basics.color.ColorTable;
import simpletree.distance.similaritymatrix.SimilarityMatrixInstance;
import simpletree.model.AbstractInstance;
import simpletree.model.AbstractModel;

public class SimilarityMatrixModel
extends AbstractModel {
    private float max;
    private float min;
    private float zoomfactor;
    private ColorTable colortable;
    private ColorTable selcolortable;
    private BufferedImage origimage;
    private static final int border = 10;

    public SimilarityMatrixModel() {
        try {
            this.max = 0.0f;
            this.min = 0.0f;
            this.zoomfactor = 1.0f;
            this.colortable = new ColorTable(ColorScaleFactory.ColorScaleType.GRAY_SCALE);
            this.selcolortable = new ColorTable(ColorScaleFactory.ColorScaleType.HEATED_OBJECTS);
            this.colortable.getColorScale().setMinMax(0.25f, 1.0f);
            this.colortable.getColorScale().setReverse(true);
        }
        catch (IOException ex) {
            Logger.getLogger(SimilarityMatrixModel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void draw(Graphics2D g2) {
        int size;
        if (this.origimage == null) {
            int i;
            size = this.instances.size();
            this.origimage = new BufferedImage(10 + size, 10 + size, 1);
            for (i = 0; i < this.instances.size(); ++i) {
                if (((AbstractInstance)this.instances.get(i)).isSelected()) continue;
                ((SimilarityMatrixInstance)this.instances.get(i)).draw(this.origimage, 10);
            }
            for (i = 0; i < this.selinstances.size(); ++i) {
                ((SimilarityMatrixInstance)this.selinstances.get(i)).draw(this.origimage, 10);
            }
            float mincdata = Float.POSITIVE_INFINITY;
            float maxcdata = Float.NEGATIVE_INFINITY;
            for (int i2 = 0; i2 < this.instances.size(); ++i2) {
                SimilarityMatrixInstance smi = (SimilarityMatrixInstance)this.instances.get(i2);
                if (mincdata > smi.getClassData()) {
                    mincdata = smi.getClassData();
                }
                if (!(maxcdata < smi.getClassData())) continue;
                maxcdata = smi.getClassData();
            }
            ColorTable legcolortable = new ColorTable(ColorScaleFactory.ColorScaleType.PSEUDO_RAINBOW_SCALE);
            Graphics2D g2Buffer = (Graphics2D)this.origimage.getGraphics();
            for (int i3 = 0; i3 < this.instances.size(); ++i3) {
                SimilarityMatrixInstance smi = (SimilarityMatrixInstance)this.instances.get(i3);
                float colorvalue = (smi.getClassData() - mincdata) / (maxcdata - mincdata);
                g2Buffer.setColor(legcolortable.getColor(colorvalue));
                g2Buffer.fillRect(0, i3, 10, i3 + 1);
                g2Buffer.fillRect(i3 + 10, size, i3 + 1 + 10, size + 10);
            }
            g2Buffer.setColor(Color.WHITE);
            g2Buffer.fillRect(0, size, 10, size + 10);
            g2Buffer.dispose();
        }
        size = (int)((float)this.origimage.getHeight() * this.zoomfactor);
        Image redimage = this.origimage.getScaledInstance(size, size, 0);
        g2.drawImage(redimage, 0, 0, null);
    }

    public ColorTable getColorTable() {
        return this.colortable;
    }

    public ColorTable getSelectionColorTable() {
        return this.selcolortable;
    }

    public float getMaxDistance() {
        return this.max;
    }

    public void setMaxDistance(float max) {
        this.max = max;
    }

    public float getMinDistance() {
        return this.min;
    }

    public void setMinDistance(float min) {
        this.min = min;
    }

    public void setZoomFactor(float zoomfactor) {
        this.zoomfactor = zoomfactor;
        this.setChanged();
    }

    public float getZoomFactor() {
        return this.zoomfactor;
    }

    public void changeColorScaleType(ColorScaleFactory.ColorScaleType scaletype) {
        this.colortable.setColorScaleType(scaletype);
        this.origimage = null;
        this.setChanged();
    }

    public Dimension getSize() {
        if (this.origimage != null) {
            int size = (int)((float)this.origimage.getHeight() * this.zoomfactor);
            return new Dimension(size, size);
        }
        return new Dimension(this.instances.size() + 10, this.instances.size() + 10);
    }

    public ArrayList<SimilarityMatrixInstance> getInstancesByPosition(Rectangle rect) {
        ArrayList<SimilarityMatrixInstance> selected = new ArrayList<SimilarityMatrixInstance>();
        rect.x = (int)((float)rect.x / this.zoomfactor - 10.0f);
        rect.y = (int)((float)rect.y / this.zoomfactor);
        rect.width = (int)((float)rect.width / this.zoomfactor);
        rect.height = (int)((float)rect.height / this.zoomfactor);
        for (int i = 0; i < this.instances.size(); ++i) {
            SimilarityMatrixInstance smi = (SimilarityMatrixInstance)this.instances.get(i);
            if (smi.getPosition() < rect.x || smi.getPosition() > rect.x + rect.width || smi.getPosition() < rect.y || smi.getPosition() > rect.y + rect.height) continue;
            selected.add(smi);
        }
        return selected;
    }

    public ArrayList<SimilarityMatrixInstance> getInstancesByPosition(Point point) {
        ArrayList<SimilarityMatrixInstance> selected = new ArrayList<SimilarityMatrixInstance>();
        for (int i = 0; i < this.instances.size(); ++i) {
            SimilarityMatrixInstance smi = (SimilarityMatrixInstance)this.instances.get(i);
            int x = (int)((float)point.x / this.zoomfactor - 10.0f);
            int y = (int)((float)point.y / this.zoomfactor);
            int width = (int)((float)this.instances.size() / this.zoomfactor) - 10;
            int height = (int)((float)this.instances.size() / this.zoomfactor);
            if ((smi.getPosition() != x || y > height) && (smi.getPosition() != y || x > width)) continue;
            selected.add(smi);
        }
        return selected;
    }

    @Override
    public void cleanSelectedInstances() {
        super.cleanSelectedInstances();
        this.origimage = null;
    }

    @Override
    public void removeInstances(ArrayList<AbstractInstance> reminst) {
        super.removeInstances(reminst);
        this.origimage = null;
    }

    @Override
    public void removeSelectedInstances() {
        super.removeSelectedInstances();
        this.origimage = null;
    }

    @Override
    public void setSelectedInstance(AbstractInstance selinst) {
        super.setSelectedInstance(selinst);
        this.origimage = null;
    }

    @Override
    public void setSelectedInstances(ArrayList<AbstractInstance> selinst) {
        super.setSelectedInstances(selinst);
        this.origimage = null;
    }
}

