/*
 * Decompiled with CFR 0.152.
 */
package simpletree.graph.technique.layout;

import java.util.ArrayList;
import java.util.HashSet;
import simpletree.graph.technique.layout.GraphLayout;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.Connectivity;
import simpletree.model.Edge;

public class RadialLayout
implements GraphLayout {
    private ArrayList<Node> nodes;
    private Node root;

    @Override
    public AbstractMatrix execute(AbstractMatrix matrix, Connectivity conn) {
        this.init(conn);
        this.postorderTraversal(this.root);
        this.root.x = 0.0f;
        this.root.y = 0.0f;
        this.root.w = (float)Math.PI * 2;
        this.root.t = 0.0f;
        this.preorderTraversal(this.root);
        DenseMatrix position = new DenseMatrix();
        int size = this.nodes.size();
        for (int i = 0; i < size; ++i) {
            float[] vect = new float[]{this.nodes.get((int)i).x, this.nodes.get((int)i).y};
            System.out.println(vect[0] + " - " + vect[1]);
            if (i < matrix.getRowCount()) {
                AbstractVector row = matrix.getRow(i);
                DenseVector vector = new DenseVector(vect, row.getId(), row.getKlass());
                position.addRow(vector);
                continue;
            }
            DenseVector vector = new DenseVector(vect, -1, -1.0f);
            position.addRow(vector);
        }
        return position;
    }

    private void init(Connectivity conn) {
        int i;
        HashSet<Integer> aux_ins = new HashSet<Integer>();
        ArrayList<Edge> edges = conn.getEdges();
        int size = edges.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Edge edge = edges.get(i2);
            aux_ins.add(edge.getSource());
            aux_ins.add(edge.getTarget());
        }
        int nrinstances = aux_ins.size();
        this.nodes = new ArrayList();
        for (i = 0; i < nrinstances; ++i) {
            Node node = new Node(i);
            this.nodes.add(node);
        }
        this.root = this.nodes.get(0);
        for (i = 0; i < size; ++i) {
            Edge edge = edges.get(i);
            Node parent = this.nodes.get(edge.getSource());
            Node ch = this.nodes.get(edge.getTarget());
            ch.parent = parent;
            ch.dist = edge.getWeight();
            parent.children.add(ch);
        }
    }

    private void postorderTraversal(Node v) {
        if (v.children.size() == 0) {
            v.l = 1.0f;
        } else {
            v.l = 0.0f;
            for (Node w : v.children) {
                this.postorderTraversal(w);
                v.l += w.l;
            }
        }
    }

    private void preorderTraversal(Node v) {
        if (v != this.root) {
            Node u = v.parent;
            v.x = u.x + v.dist * (float)Math.cos(v.t + v.w / 2.0f);
            v.y = u.y + v.dist * (float)Math.sin(v.t + v.w / 2.0f);
        }
        float n = v.t;
        for (Node w : v.children) {
            w.w = w.l / this.root.l * ((float)Math.PI * 2);
            w.t = n;
            n += w.w;
            this.preorderTraversal(w);
        }
    }

    public class Node {
        public int id;
        public float x;
        public float y;
        public float w;
        public float t;
        public float l;
        public Node parent;
        public float dist;
        public ArrayList<Node> children = new ArrayList();

        public Node(int id) {
            this.id = id;
        }
    }
}

