/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.label;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;

public class TreeLabel {
    private List<String> labels = new ArrayList<String>();
    private long start = 0L;
    private long end = 0L;

    public static void main(String[] args) throws IOException {
        AbstractMatrix mat = MatrixFactory.getInstance("/home/renato/corel1000.data");
        TreeLabel labels = new TreeLabel();
        labels.extract(mat);
        labels.save("/home/renato/corel1000.blabels");
        labels.load("/home/renato/corel1000.blabels");
        labels = new TreeLabel();
        String label = labels.read(0, "/home/renato/corel1000.blabels");
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void set(List<String> labels) {
        this.labels = labels;
    }

    public String get(int id) {
        if (id > this.labels.size() - 1) {
            return null;
        }
        return this.labels.get(id);
    }

    public void extract(AbstractMatrix matrix) {
        this.labels = matrix.getLabels();
    }

    public void save(String filename) throws FileNotFoundException, IOException {
        int blockSize = 16;
        try (RandomAccessFile out = new RandomAccessFile(filename, "rw");){
            out.seek(this.start);
            out.writeInt(this.labels.size());
            long stringOffset = this.start + 4L + (long)(blockSize * this.labels.size()) + 4L;
            String concatenation = "";
            for (int i = 0; i < this.labels.size(); ++i) {
                out.writeInt(i);
                out.writeLong(stringOffset);
                out.writeInt(this.labels.get(i).getBytes().length);
                concatenation = concatenation + this.labels.get(i);
                stringOffset += (long)this.labels.get(i).getBytes().length;
            }
            int concatLength = concatenation.length();
            out.writeInt(concatLength);
            out.write(concatenation.getBytes());
            this.end = out.getFilePointer();
        }
    }

    public String read(int id, String filename) throws FileNotFoundException, IOException {
        String label;
        int blockSize = 16;
        try (RandomAccessFile in = new RandomAccessFile(filename, "r");){
            in.seek(this.start);
            int labelsSize = in.readInt();
            in.seek((long)(4 + id * blockSize) + this.start);
            int readId = in.readInt();
            long offset = in.readLong();
            int length = in.readInt();
            byte[] labelBytes = new byte[length];
            in.seek(offset);
            in.read(labelBytes);
            label = new String(labelBytes);
        }
        return label;
    }

    public void load(String filename) throws FileNotFoundException, IOException {
        this.labels = new ArrayList<String>();
        int blockSize = 16;
        try (RandomAccessFile in = new RandomAccessFile(filename, "r");){
            in.seek(this.start);
            int labelsSize = in.readInt();
            in.seek((long)(4 + blockSize * labelsSize) + this.start);
            int concatSize = in.readInt();
            byte[] concatBytes = new byte[concatSize];
            in.read(concatBytes);
            String concatLabels = new String(concatBytes);
            in.seek(4L + this.start);
            byte[] buffer = new byte[16 * labelsSize];
            in.read(buffer);
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            for (int i = 0; i < labelsSize; ++i) {
                int id = byteBuffer.getInt();
                long offset = byteBuffer.getLong();
                int length = byteBuffer.getInt();
                String label = concatLabels.substring((int)(offset -= this.start + 4L + (long)(blockSize * labelsSize) + 4L), (int)offset + length);
                this.labels.add(label);
            }
        }
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }
}

