/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.tree;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.io.tree.NewickConversor;
import simpletree.io.tree.Node;
import simpletree.io.tree.PexMatrix;
import simpletree.io.tree.Sort;
import simpletree.io.util.DistanceMatrixReader;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;

public class NeighborJoining {
    private Algorithm algorithm = Algorithm.Rapid;
    private int nextVirtualId;

    public static void main(String[] args) throws IOException {
        AbstractMatrix matrix = MatrixFactory.getInstance("/home/renato/corel10.data");
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        NeighborJoining nj = new NeighborJoining();
        nj.setNextVirtualId(matrix.getRowCount());
        Node rootNode = nj.execute(matrix, diss);
        String newickTree = NewickConversor.buildString(rootNode);
        System.out.println(newickTree);
    }

    public Node execute(DistanceMatrix distMatrix) {
        Node treeRoot;
        PexMatrix pexMatrix = DistanceMatrixReader.loadPex(distMatrix);
        if (distMatrix.getElementCount() < 3) {
            treeRoot = new Node(this.nextVirtualId);
            for (int i = 0; i < pexMatrix.n; ++i) {
                Node child = new Node(pexMatrix.ids[i]);
                child.parent = treeRoot;
                treeRoot.children.add(child);
                treeRoot.distance.add(pexMatrix.getDistance(0, 1));
            }
            ++this.nextVirtualId;
        } else {
            treeRoot = this.algorithm == Algorithm.Rapid ? this.rapidNJ(pexMatrix) : (this.algorithm == Algorithm.Fast ? this.fastNJ(pexMatrix) : this.originalNJ(pexMatrix));
        }
        return treeRoot;
    }

    public Node execute(AbstractMatrix matrix, AbstractDissimilarity diss) {
        Node treeRoot;
        PexMatrix pexMatrix = DistanceMatrixReader.loadPex(matrix, diss);
        if (matrix.getRowCount() == 1) {
            treeRoot = new Node(pexMatrix.ids[0]);
        } else if (matrix.getRowCount() == 2) {
            treeRoot = new Node(this.nextVirtualId);
            for (int i = 0; i < pexMatrix.n; ++i) {
                Node child = new Node(pexMatrix.ids[i]);
                child.parent = treeRoot;
                treeRoot.children.add(child);
                treeRoot.distance.add(pexMatrix.getDistance(0, 1));
            }
            ++this.nextVirtualId;
        } else {
            treeRoot = this.algorithm == Algorithm.Rapid ? this.rapidNJ(pexMatrix) : (this.algorithm == Algorithm.Fast ? this.fastNJ(pexMatrix) : this.originalNJ(pexMatrix));
        }
        return treeRoot;
    }

    private Node originalNJ(PexMatrix p) {
        double Sum = 0.0;
        double[] sum = new double[p.n];
        double[] joined = new double[p.n];
        String[] newick = new String[p.n];
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int k = 0; k < p.n; ++k) {
            int x;
            newick[k] = p.ids == null ? Integer.toString(k) : Integer.toString(p.ids[k]);
            sum[k] = 0.0;
            nodes.put(Integer.parseInt(newick[k]), new Node(Integer.parseInt(newick[k])));
            for (x = 0; x < k; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[k][x];
                Sum += p.M[k][x];
            }
            for (x = k + 1; x < p.n; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[x][k];
                Sum += p.M[x][k];
            }
        }
        int nextId = this.nextVirtualId;
        while (p.n > 2) {
            int k;
            double smin = Double.MAX_VALUE;
            int imin = 0;
            int jmin = 0;
            for (int i = 1; i < p.n; ++i) {
                for (int j = 0; j < i; ++j) {
                    double s = (sum[i] - p.M[i][j] + sum[j] - p.M[i][j]) / (double)(2 * (p.n - 2)) + p.M[i][j] / 2.0 + (Sum - sum[i] - sum[j] + p.M[i][j]) / (double)(p.n - 2);
                    if (!(s < smin)) continue;
                    smin = s;
                    imin = i;
                    jmin = j;
                }
            }
            double dikmin = (sum[imin] - p.M[imin][jmin]) / (double)(p.n - 2);
            double djkmin = (sum[jmin] - p.M[imin][jmin]) / (double)(p.n - 2);
            String oldvalue = newick[jmin];
            newick[jmin] = "(" + newick[imin] + ":" + new Formatter().format(Locale.US, "%1.2f", (p.M[imin][jmin] + dikmin - djkmin) / 2.0 - joined[imin]).toString() + "," + newick[jmin] + ":" + new Formatter().format(Locale.US, "%1.2f", (p.M[imin][jmin] + djkmin - dikmin) / 2.0 - joined[jmin]).toString() + ")" + Integer.toString(nextId);
            int id = nextId++;
            Node node = new Node(id);
            node.distance.add((p.M[imin][jmin] + dikmin - djkmin) / 2.0 - joined[imin]);
            node.distance.add((p.M[imin][jmin] + djkmin - dikmin) / 2.0 - joined[jmin]);
            if (newick[imin].lastIndexOf(")") != -1) {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[imin].substring(newick[imin].lastIndexOf(")") + 1))));
            } else {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[imin])));
            }
            if (oldvalue.lastIndexOf(")") != -1) {
                node.children.add((Node)nodes.get(Integer.parseInt(oldvalue.substring(oldvalue.lastIndexOf(")") + 1))));
            } else {
                node.children.add((Node)nodes.get(Integer.parseInt(oldvalue)));
            }
            nodes.put(id, node);
            joined[jmin] = p.M[imin][jmin] / 2.0;
            sum[jmin] = 0.0;
            for (k = 0; k < jmin; ++k) {
                if (k == imin) continue;
                Sum -= p.M[jmin][k];
                int n = k;
                sum[n] = sum[n] - p.M[jmin][k];
                p.M[jmin][k] = (p.M[jmin][k] + (k < imin ? p.M[imin][k] : p.M[k][imin])) / 2.0;
                Sum += p.M[jmin][k];
                int n2 = k;
                sum[n2] = sum[n2] + p.M[jmin][k];
                int n3 = jmin;
                sum[n3] = sum[n3] + p.M[jmin][k];
            }
            for (k = jmin + 1; k < p.n; ++k) {
                if (k == imin) continue;
                Sum -= p.M[k][jmin];
                int n = k;
                sum[n] = sum[n] - p.M[k][jmin];
                p.M[k][jmin] = (p.M[k][jmin] + (k < imin ? p.M[imin][k] : p.M[k][imin])) / 2.0;
                Sum += p.M[k][jmin];
                int n4 = k;
                sum[n4] = sum[n4] + p.M[k][jmin];
                int n5 = jmin;
                sum[n5] = sum[n5] + p.M[k][jmin];
            }
            int n = jmin;
            sum[n] = sum[n] + p.M[imin][jmin];
            for (k = 0; k < imin; ++k) {
                Sum -= p.M[imin][k];
                int n6 = k;
                sum[n6] = sum[n6] - p.M[imin][k];
                p.M[imin][k] = p.M[p.n - 1][k];
            }
            for (k = imin + 1; k < p.n - 1; ++k) {
                Sum -= p.M[k][imin];
                int n7 = k;
                sum[n7] = sum[n7] - p.M[k][imin];
                p.M[k][imin] = p.M[p.n - 1][k];
            }
            Sum -= p.M[p.n - 1][imin];
            newick[imin] = newick[p.n - 1];
            joined[imin] = joined[p.n - 1];
            sum[imin] = sum[p.n - 1] - p.M[p.n - 1][imin];
            --p.n;
        }
        double x = (p.M[1][0] + p.M[2][0] - p.M[2][1]) / 2.0 - joined[0];
        double y = (p.M[1][0] + p.M[2][1] - p.M[2][0]) / 2.0 - joined[1];
        double z = (p.M[2][0] + p.M[2][1] - p.M[1][0]) / 2.0 - joined[2];
        int id = nextId;
        Node node = new Node(id);
        node.distance.add(x);
        node.distance.add(y);
        node.distance.add(z);
        if (newick[0].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[0].substring(newick[0].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[0])));
        }
        if (newick[1].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[1].substring(newick[1].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[1])));
        }
        if (newick[2].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[2].substring(newick[2].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[2])));
        }
        nodes.put(id, node);
        this.nextVirtualId = nextId;
        return node;
    }

    private Node fastNJ(PexMatrix p) {
        int nextId = p.n;
        String[] newick = new String[p.n];
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < p.n; ++i) {
            newick[i] = p.ids == null ? Integer.toString(i) : Integer.toString(p.ids[i]);
            nodes.put(Integer.parseInt(newick[i]), new Node(Integer.parseInt(newick[i])));
        }
        nextId = this.nextVirtualId;
        double[] sum = new double[p.n];
        for (int k = 0; k < p.n; ++k) {
            int x;
            sum[k] = 0.0;
            for (x = 0; x < k; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[k][x];
            }
            for (x = k + 1; x < p.n; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[x][k];
            }
        }
        class ClosestPair {
            public int j;
            public double d;

            ClosestPair() {
            }
        }
        ClosestPair[] C = new ClosestPair[p.n + 1];
        int c = p.n;
        for (int i = 0; i < p.n; ++i) {
            double s;
            int j;
            C[i] = new ClosestPair();
            C[i].d = Double.MAX_VALUE;
            for (j = 0; j < i; ++j) {
                s = p.M[i][j] - (sum[i] + sum[j]) / (double)(p.n - 2);
                if (!(s < C[i].d)) continue;
                C[i].d = s;
                C[i].j = j;
            }
            for (j = i + 1; j < p.n; ++j) {
                s = p.M[j][i] - (sum[i] + sum[j]) / (double)(p.n - 2);
                if (!(s < C[i].d)) continue;
                C[i].d = s;
                C[i].j = j;
            }
        }
        while (p.n > 3) {
            int k;
            int jmin;
            int imin;
            int cmin = 0;
            for (int i = 1; i < c; ++i) {
                if (!(C[i].d < C[cmin].d)) continue;
                cmin = i;
            }
            if (cmin > C[cmin].j) {
                imin = cmin;
                jmin = C[cmin].j;
            } else {
                imin = C[cmin].j;
                jmin = cmin;
            }
            double lik = 0.5 * (p.M[imin][jmin] + (sum[imin] - sum[jmin]) / (double)(p.n - 2));
            double ljk = p.M[imin][jmin] - lik;
            String oldvalue = newick[jmin];
            newick[jmin] = "(" + newick[imin] + ":" + new Formatter().format(Locale.US, "%.2f", lik).toString() + "," + newick[jmin] + ":" + new Formatter().format(Locale.US, "%.2f", ljk).toString() + ")" + Integer.toString(nextId);
            int id = nextId++;
            Node node = new Node(id);
            node.distance.add(Math.abs(lik));
            node.distance.add(Math.abs(ljk));
            if (newick[imin].lastIndexOf(")") != -1) {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[imin].substring(newick[imin].lastIndexOf(")") + 1))));
            } else {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[imin])));
            }
            if (oldvalue.lastIndexOf(")") != -1) {
                node.children.add((Node)nodes.get(Integer.parseInt(oldvalue.substring(oldvalue.lastIndexOf(")") + 1))));
            } else {
                node.children.add((Node)nodes.get(Integer.parseInt(oldvalue)));
            }
            nodes.put(id, node);
            sum[jmin] = 0.0;
            for (k = 0; k < jmin; ++k) {
                if (k == imin) continue;
                int n = k;
                sum[n] = sum[n] - p.M[jmin][k];
                p.M[jmin][k] = (p.M[jmin][k] + (k < imin ? p.M[imin][k] : p.M[k][imin]) - p.M[imin][jmin]) / 2.0;
                int n2 = k;
                sum[n2] = sum[n2] + p.M[jmin][k];
                int n3 = jmin;
                sum[n3] = sum[n3] + p.M[jmin][k];
            }
            for (k = jmin + 1; k < p.n; ++k) {
                if (k == imin) continue;
                int n = k;
                sum[n] = sum[n] - p.M[k][jmin];
                p.M[k][jmin] = (p.M[k][jmin] + (k < imin ? p.M[imin][k] : p.M[k][imin]) - p.M[imin][jmin]) / 2.0;
                int n4 = k;
                sum[n4] = sum[n4] + p.M[k][jmin];
                int n5 = jmin;
                sum[n5] = sum[n5] + p.M[k][jmin];
            }
            int n = jmin;
            sum[n] = sum[n] + p.M[imin][jmin];
            for (k = 0; k < imin; ++k) {
                int n6 = k;
                sum[n6] = sum[n6] - p.M[imin][k];
                p.M[imin][k] = p.M[p.n - 1][k];
            }
            for (k = imin + 1; k < p.n - 1; ++k) {
                int n7 = k;
                sum[n7] = sum[n7] - p.M[k][imin];
                p.M[k][imin] = p.M[p.n - 1][k];
            }
            newick[imin] = newick[p.n - 1];
            sum[imin] = sum[p.n - 1] - p.M[p.n - 1][imin];
            --p.n;
            ClosestPair a = C[imin];
            C[imin] = C[--c];
            C[c] = a;
            for (int i = 0; i < c; ++i) {
                if (i == jmin || C[i].j == imin || C[i].j == jmin) {
                    double s;
                    int j;
                    C[i].d = Double.MAX_VALUE;
                    for (j = 0; j < i; ++j) {
                        s = p.M[i][j] - (sum[i] + sum[j]) / (double)(p.n - 2);
                        if (!(s < C[i].d)) continue;
                        C[i].d = s;
                        C[i].j = j;
                    }
                    for (j = i + 1; j < p.n; ++j) {
                        s = p.M[j][i] - (sum[i] + sum[j]) / (double)(p.n - 2);
                        if (!(s < C[i].d)) continue;
                        C[i].d = s;
                        C[i].j = j;
                    }
                    continue;
                }
                if (C[i].j != p.n) continue;
                C[i].j = imin;
            }
        }
        double x = (p.M[1][0] + p.M[2][0] - p.M[2][1]) / 2.0;
        double y = (p.M[1][0] + p.M[2][1] - p.M[2][0]) / 2.0;
        double z = (p.M[2][0] + p.M[2][1] - p.M[1][0]) / 2.0;
        int id = nextId;
        Node node = new Node(id);
        node.distance.add(x);
        node.distance.add(y);
        node.distance.add(z);
        if (newick[0].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[0].substring(newick[0].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[0])));
        }
        if (newick[1].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[1].substring(newick[1].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[1])));
        }
        if (newick[2].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[2].substring(newick[2].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[2])));
        }
        nodes.put(id, node);
        this.nextVirtualId = nextId + 1;
        return node;
    }

    private Node rapidNJ(PexMatrix p) {
        Node node;
        int id;
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        int nextId = p.n;
        if (p.n < 3) {
            System.out.println("");
        }
        double[][] E = new double[2 * p.n - 3][];
        for (int i = 0; i < p.n; ++i) {
            E[i] = p.M[i];
        }
        p.M = E;
        String[] newick = new String[2 * p.n - 3];
        for (int i = 0; i < p.n; ++i) {
            newick[i] = p.ids == null ? Integer.toString(i) : Integer.toString(p.ids[i]);
            nodes.put(Integer.parseInt(newick[i]), new Node(Integer.parseInt(newick[i])));
        }
        nextId = this.nextVirtualId;
        double[][] S = new double[2 * p.n - 3][];
        int[][] I = new int[2 * p.n - 3][];
        for (int i = 0; i < p.n; ++i) {
            S[i] = new double[i + 1];
            I[i] = new int[i + 1];
            for (int j = 0; j < i; ++j) {
                S[i][j] = p.M[i][j];
            }
            Sort.qsort(S[i], I[i], 0, i);
        }
        double[] sum = new double[2 * p.n - 3];
        double smax = Double.MIN_VALUE;
        for (int k = 0; k < p.n; ++k) {
            int x;
            sum[k] = 0.0;
            for (x = 0; x < k; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[k][x];
            }
            for (x = k + 1; x < p.n; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[x][k];
            }
            if (!(sum[k] > smax)) continue;
            smax = sum[k];
        }
        int l = p.n;
        while (p.n > 3) {
            int k;
            double smin = Double.MAX_VALUE;
            int imin = 0;
            int jmin = 0;
            block8: for (int i = l - 1; i >= 0; --i) {
                if (p.M[i] == null) continue;
                for (int j = 0; j < i; ++j) {
                    if (p.M[I[i][j]] == null) continue;
                    if (!(S[i][j] < Double.MAX_VALUE) || !(S[i][j] - (sum[i] + smax) / (double)(p.n - 2) < smin)) continue block8;
                    double s = S[i][j] - (sum[i] + sum[I[i][j]]) / (double)(p.n - 2);
                    if (!(s < smin)) continue;
                    smin = s;
                    imin = i;
                    jmin = I[i][j];
                }
            }
            double lik = 0.5 * (p.M[imin][jmin] + (sum[imin] - sum[jmin]) / (double)(p.n - 2));
            double ljk = p.M[imin][jmin] - lik;
            newick[l] = "(" + newick[imin] + ":" + new Formatter().format(Locale.US, "%.2f", lik).toString() + "," + newick[jmin] + ":" + new Formatter().format(Locale.US, "%.2f", ljk).toString() + ")" + Integer.toString(nextId);
            id = nextId++;
            node = new Node(id);
            node.distance.add(lik);
            node.distance.add(ljk);
            if (newick[imin].lastIndexOf(")") != -1) {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[imin].substring(newick[imin].lastIndexOf(")") + 1))));
            } else {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[imin])));
            }
            if (newick[jmin].lastIndexOf(")") != -1) {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[jmin].substring(newick[jmin].lastIndexOf(")") + 1))));
            } else {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[jmin])));
            }
            nodes.put(id, node);
            newick[jmin] = null;
            newick[imin] = null;
            sum[l] = 0.0;
            p.M[l] = new double[l + 1];
            S[l] = new double[l + 1];
            I[l] = new int[l + 1];
            for (k = 0; k < jmin; ++k) {
                if (k != imin && p.M[k] != null) {
                    int n = k;
                    sum[n] = sum[n] - p.M[jmin][k];
                    p.M[l][k] = (p.M[jmin][k] + (k < imin ? p.M[imin][k] : p.M[k][imin]) - p.M[imin][jmin]) / 2.0;
                    S[l][k] = p.M[l][k];
                    int n2 = l;
                    sum[n2] = sum[n2] + p.M[l][k];
                    int n3 = k;
                    sum[n3] = sum[n3] + p.M[l][k];
                    continue;
                }
                S[l][k] = Double.MAX_VALUE;
            }
            for (k = jmin + 1; k < l; ++k) {
                if (k != imin && p.M[k] != null) {
                    int n = k;
                    sum[n] = sum[n] - p.M[k][jmin];
                    p.M[l][k] = (p.M[k][jmin] + (k < imin ? p.M[imin][k] : p.M[k][imin]) - p.M[imin][jmin]) / 2.0;
                    S[l][k] = p.M[l][k];
                    int n4 = l;
                    sum[n4] = sum[n4] + p.M[l][k];
                    int n5 = k;
                    sum[n5] = sum[n5] + p.M[l][k];
                    continue;
                }
                S[l][k] = Double.MAX_VALUE;
            }
            for (k = 0; k < imin; ++k) {
                if (k == jmin || p.M[k] == null) continue;
                int n = k;
                sum[n] = sum[n] - p.M[imin][k];
            }
            for (k = imin + 1; k < l; ++k) {
                if (k == jmin || p.M[k] == null) continue;
                int n = k;
                sum[n] = sum[n] - p.M[k][imin];
            }
            Sort.qsort(S[l], I[l], 0, l);
            p.M[jmin] = null;
            p.M[imin] = null;
            S[jmin] = null;
            S[imin] = null;
            I[jmin] = null;
            I[imin] = null;
            smax = Double.MIN_VALUE;
            for (k = 0; k < l; ++k) {
                if (p.M[k] == null || !(sum[k] > smax)) continue;
                smax = sum[k];
            }
            --p.n;
            ++l;
        }
        int a = 0;
        while (true) {
            if (p.M[a] != null) break;
            ++a;
        }
        int i = a++;
        while (true) {
            if (p.M[a] != null) break;
            ++a;
        }
        int j = a++;
        while (true) {
            if (p.M[a] != null) break;
            ++a;
        }
        int k = a;
        double x = (p.M[j][i] + p.M[k][i] - p.M[k][j]) / 2.0;
        double y = (p.M[j][i] + p.M[k][j] - p.M[k][i]) / 2.0;
        double z = (p.M[k][i] + p.M[k][j] - p.M[j][i]) / 2.0;
        id = nextId;
        node = new Node(id);
        node.distance.add(x);
        node.distance.add(y);
        node.distance.add(z);
        if (newick[i].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[i].substring(newick[i].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[i])));
        }
        if (newick[j].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[j].substring(newick[j].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[j])));
        }
        if (newick[k].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[k].substring(newick[k].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[k])));
        }
        nodes.put(id, node);
        this.nextVirtualId = nextId + 1;
        return node;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public int getNextVirtualId() {
        return this.nextVirtualId;
    }

    public void setNextVirtualId(int nextVirtualId) {
        this.nextVirtualId = nextVirtualId;
    }

    public static enum Algorithm {
        Original(0),
        Fast(1),
        Rapid(2);

        int code;

        private Algorithm(int code) {
            this.code = code;
        }
    }
}

