/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix;

import java.io.IOException;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.matrix.sparse.SparseMatrix;
import simpletree.matrix.sparse.SparseVector;

public class VectorFactory {
    public static AbstractVector getInstance(Class matrixtype, float[] vect) throws IOException {
        return VectorFactory.getInstance(matrixtype, vect, 0, 0.0f);
    }

    public static AbstractVector getInstance(Class matrixtype, float[] vect, float klass) throws IOException {
        return VectorFactory.getInstance(matrixtype, vect, 0, klass);
    }

    public static AbstractVector getInstance(Class matrixtype, float[] vect, int id) throws IOException {
        return VectorFactory.getInstance(matrixtype, vect, id, 0.0f);
    }

    public static AbstractVector getInstance(Class matrixtype, float[] vect, int id, float klass) throws IOException {
        if (DenseMatrix.class.isAssignableFrom(matrixtype)) {
            return new DenseVector(vect, id, klass);
        }
        if (SparseMatrix.class.isAssignableFrom(matrixtype)) {
            return new SparseVector(vect, id, klass);
        }
        return null;
    }
}

