/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.dense;

import java.io.BufferedWriter;
import java.io.IOException;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.sparse.SparseVector;

public class DenseVector
extends AbstractVector {
    public DenseVector(float[] vector) {
        this.create(vector, 0, 0.0f);
    }

    public DenseVector(float[] vector, int id) {
        this.create(vector, id, 0.0f);
    }

    public DenseVector(float[] vector, float klass) {
        this.create(vector, 0, klass);
    }

    public DenseVector(float[] vector, int id, float klass) {
        this.create(vector, id, klass);
    }

    @Override
    public float dot(AbstractVector vector) {
        assert (this.size == vector.size()) : "ERROR: vectors of different sizes!";
        float dot = 0.0f;
        if (vector instanceof DenseVector) {
            int length = this.values.length;
            for (int i = 0; i < length; ++i) {
                dot += this.values[i] * vector.getValues()[i];
            }
        } else {
            int length = ((SparseVector)vector).getIndex().length;
            for (int i = 0; i < length; ++i) {
                dot += this.values[((SparseVector)vector).getIndex()[i]] * vector.getValues()[i];
            }
        }
        return dot;
    }

    @Override
    public void normalize() {
        assert (this.norm() != 0.0f) : "ERROR: it is not possible to normalize a null vector!";
        if (this.norm() > 1.0E-5f) {
            int length = this.values.length;
            for (int i = 0; i < length; ++i) {
                this.values[i] = this.values[i] / this.norm();
            }
            this.norm = 1.0f;
        } else {
            this.norm = 0.0f;
        }
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.values.length];
        System.arraycopy(this.values, 0, array, 0, this.values.length);
        return array;
    }

    @Override
    public float getValue(int index) {
        assert (index <= this.size) : "ERROR: vector can not be null!";
        return this.values[index];
    }

    @Override
    public void setValue(int index, float value) {
        assert (index <= this.size) : "ERROR: vector can not be null!";
        this.updateNorm = true;
        this.values[index] = value;
    }

    @Override
    public void write(BufferedWriter out) throws IOException {
        for (int i = 0; i < this.values.length; ++i) {
            out.write(Float.toString(this.values[i]));
            out.write(";");
        }
        out.write(Float.toString(this.klass));
    }

    @Override
    protected final void create(float[] vector, int id, float klass) {
        assert (vector != null) : "ERROR: vector can not be null!";
        this.values = vector;
        this.size = vector.length;
        this.id = id;
        this.klass = klass;
        this.updateNorm = true;
    }

    @Override
    protected void updateNorm() {
        this.norm = 0.0f;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            this.norm += this.values[i] * this.values[i];
        }
        this.norm = (float)Math.sqrt(this.norm);
        this.updateNorm = false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DenseVector clone = new DenseVector(new float[]{0.0f});
        clone.norm = this.norm;
        clone.size = this.size;
        clone.id = this.id;
        clone.klass = this.klass;
        if (this.values != null) {
            clone.values = new float[this.values.length];
            System.arraycopy(this.values, 0, clone.values, 0, this.values.length);
        }
        return clone;
    }
}

