/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.sparse;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.sparse.Element;
import simpletree.matrix.sparse.SparseVector;
import simpletree.util.Util;

public class SparseMatrix
extends AbstractMatrix {
    @Override
    public void addRow(AbstractVector vector) {
        assert (vector instanceof SparseVector) : "ERROR: vector of wrong type!";
        super.addRow(vector);
    }

    @Override
    public void setRow(int index, AbstractVector vector) {
        assert (vector instanceof SparseVector) : "ERROR: vector of wrong type!";
        super.setRow(index, vector);
    }

    @Override
    public void load(String filename) throws IOException {
        this.rows = new ArrayList();
        this.attributes = new ArrayList();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            char[] header = in.readLine().trim().toCharArray();
            if (header.length != 2) {
                throw new IOException("Wrong format of header information.");
            }
            if (header[0] != 'S') {
                throw new IOException("Wrong matrix format. It is not the sparse format.");
            }
            int nrobjs = Integer.parseInt(in.readLine());
            int nrdims = Integer.parseInt(in.readLine());
            String line = in.readLine();
            StringTokenizer t1 = new StringTokenizer(line, ";");
            while (t1.hasMoreTokens()) {
                String token = t1.nextToken();
                this.attributes.add(token.trim());
            }
            if (this.attributes.size() > 0 && this.attributes.size() != nrdims) {
                throw new IOException("The number of attributes does not match with the dimensionality of matrix (" + this.attributes.size() + " - " + nrdims + ").");
            }
            int lineIndex = 0;
            while ((line = in.readLine()) != null && line.trim().length() > 0) {
                StringTokenizer t2 = new StringTokenizer(line, ";");
                String id = t2.nextToken().trim();
                float klass = 0.0f;
                ArrayList<Element> values = new ArrayList<Element>();
                while (t2.hasMoreTokens()) {
                    float value;
                    int index;
                    StringTokenizer t3;
                    String token = t2.nextToken();
                    if (header[1] == 'Y') {
                        if (t2.hasMoreTokens()) {
                            t3 = new StringTokenizer(token, ":");
                            index = Integer.parseInt(t3.nextToken().trim());
                            value = Float.parseFloat(t3.nextToken().trim());
                            values.add(new Element(index, value));
                            continue;
                        }
                        klass = Float.parseFloat(token.trim());
                        continue;
                    }
                    if (header[1] == 'N') {
                        t3 = new StringTokenizer(token, ":");
                        index = Integer.parseInt(t3.nextToken().trim());
                        value = Float.parseFloat(t3.nextToken().trim());
                        values.add(new Element(index, value));
                        continue;
                    }
                    throw new IOException("Unknown class data option");
                }
                if (Util.isParsableToInt(id)) {
                    this.addRow(new SparseVector(values, Integer.parseInt(id), klass, nrdims));
                } else {
                    this.addRow(new SparseVector(values, lineIndex, klass, nrdims), id);
                }
                ++lineIndex;
            }
            if (this.getRowCount() != nrobjs) {
                throw new IOException("The number of vectors does not match with the matrix size (" + this.getRowCount() + " - " + nrobjs + ").");
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File " + filename + " does not exist!");
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SparseMatrix.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public void save(String filename) throws IOException {
        BufferedWriter out = null;
        try {
            int i;
            out = new BufferedWriter(new FileWriter(filename));
            out.write("SY\r\n");
            out.write(Integer.toString(this.getRowCount()));
            out.write("\r\n");
            out.write(Integer.toString(this.getDimensions()));
            out.write("\r\n");
            if (this.attributes != null) {
                for (i = 0; i < this.attributes.size(); ++i) {
                    out.write(((String)this.attributes.get(i)).replaceAll("<>", " ").trim());
                    if (i >= this.attributes.size() - 1) continue;
                    out.write(";");
                }
                out.write("\r\n");
            } else {
                out.write("\r\n");
            }
            for (i = 0; i < this.getRowCount(); ++i) {
                if (this.labels.size() > 0) {
                    out.write((String)this.labels.get(i));
                } else {
                    out.write(Integer.toString(((AbstractVector)this.rows.get(i)).getId()));
                }
                out.write(";");
                ((AbstractVector)this.rows.get(i)).write(out);
                out.write("\r\n");
            }
        }
        catch (IOException ex) {
            throw new IOException("Problems written \"" + filename + "\"!");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SparseMatrix.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SparseMatrix clone = new SparseMatrix();
        clone.dimensions = this.dimensions;
        for (String lab : this.labels) {
            clone.labels.add(lab);
        }
        for (String attr : this.attributes) {
            clone.attributes.add(attr);
        }
        for (AbstractVector v : this.rows) {
            clone.rows.add((SparseVector)v.clone());
        }
        return clone;
    }
}

