/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.sparse;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.sparse.Element;

public class SparseVector
extends AbstractVector {
    protected int[] index;

    public SparseVector(float[] vector) {
        this.create(vector, 0, 0.0f);
    }

    public SparseVector(float[] vector, int id) {
        this.create(vector, id, 0.0f);
    }

    public SparseVector(float[] vector, float klass) {
        this.create(vector, 0, klass);
    }

    public SparseVector(float[] vector, int id, float klass) {
        this.create(vector, id, klass);
    }

    public SparseVector(ArrayList<Element> values, int id, float klass, int size) {
        assert (values != null) : "ERROR: vector can not be null!";
        this.id = id;
        this.klass = klass;
        this.size = size;
        this.index = new int[values.size()];
        this.values = new float[values.size()];
        int length = this.index.length;
        for (int i = 0; i < length; ++i) {
            this.index[i] = values.get((int)i).index;
            this.values[i] = values.get((int)i).value;
        }
        this.updateNorm = true;
    }

    @Override
    public float dot(AbstractVector vector) {
        assert (this.size == vector.size()) : "ERROR: vectors of different sizes!";
        float dot = 0.0f;
        if (vector instanceof SparseVector) {
            int length = this.index.length;
            int vlength = ((SparseVector)vector).index.length;
            int[] vindex = ((SparseVector)vector).index;
            float[] vvalues = vector.getValues();
            if (length > 0 && vlength > 0 && this.index[0] <= vindex[vlength - 1]) {
                int j = 0;
                for (int i = 0; i < length; ++i) {
                    while (j + 1 <= vlength && vindex[j] < this.index[i]) {
                        ++j;
                    }
                    if (j < vlength) {
                        if (this.index[i] != vindex[j]) continue;
                        dot += this.values[i] * vvalues[j];
                        ++j;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int length = this.index.length;
            for (int i = 0; i < length; ++i) {
                dot += this.values[i] * vector.getValues()[this.index[i]];
            }
        }
        return dot;
    }

    @Override
    public void normalize() {
        assert (this.norm() > 0.0f) : "ERROR: it is not possible to normalize a null vector!";
        if (this.norm() > 1.0E-5f) {
            int length = this.values.length;
            for (int i = 0; i < length; ++i) {
                this.values[i] = this.values[i] / this.norm();
            }
            this.norm = 1.0f;
        } else {
            this.norm = 0.0f;
        }
    }

    @Override
    protected final void create(float[] vector, int id, float klass) {
        assert (vector != null) : "ERROR: vector can not be null!";
        this.id = id;
        this.klass = klass;
        this.size = vector.length;
        ArrayList<Integer> index_aux = new ArrayList<Integer>();
        ArrayList<Float> values_aux = new ArrayList<Float>();
        for (int i = 0; i < vector.length; ++i) {
            if (!(vector[i] > 0.0f)) continue;
            index_aux.add(i);
            values_aux.add(Float.valueOf(vector[i]));
        }
        this.index = new int[index_aux.size()];
        this.values = new float[values_aux.size()];
        int length = this.index.length;
        for (int i = 0; i < length; ++i) {
            this.index[i] = (Integer)index_aux.get(i);
            this.values[i] = ((Float)values_aux.get(i)).floatValue();
        }
        this.updateNorm = true;
    }

    @Override
    protected void updateNorm() {
        this.norm = 0.0f;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            this.norm += this.values[i] * this.values[i];
        }
        this.norm = (float)Math.sqrt(this.norm);
        this.updateNorm = false;
    }

    public float sparsity() {
        if (this.size > 0) {
            return 1.0f - (float)this.index.length / (float)this.size;
        }
        return 1.0f;
    }

    @Override
    public float[] toArray() {
        float[] vector = new float[this.size];
        Arrays.fill(vector, 0.0f);
        int length = this.index.length;
        for (int i = 0; i < length; ++i) {
            vector[this.index[i]] = this.values[i];
        }
        return vector;
    }

    @Override
    public float getValue(int index) {
        assert (index < this.size) : "ERROR: index out of bounds!";
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i] == index) {
                return this.values[i];
            }
            if (this.index[i] > index) break;
        }
        return 0.0f;
    }

    @Override
    public void setValue(int index, float value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void write(BufferedWriter out) throws IOException {
        for (int i = 0; i < this.values.length; ++i) {
            out.write(Integer.toString(this.index[i]));
            out.write(":");
            out.write(Float.toString(this.values[i]));
            out.write(";");
        }
        out.write(Float.toString(this.klass));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SparseVector clone = new SparseVector(new float[]{0.0f});
        clone.norm = this.norm;
        clone.size = this.size;
        clone.id = this.id;
        clone.klass = this.klass;
        if (this.index != null) {
            clone.index = new int[this.index.length];
            System.arraycopy(this.index, 0, clone.index, 0, this.index.length);
        }
        if (this.values != null) {
            clone.values = new float[this.values.length];
            System.arraycopy(this.values, 0, clone.values, 0, this.values.length);
        }
        return clone;
    }

    public int[] getIndex() {
        return this.index;
    }
}

