/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.matrix.sparse.SparseMatrix;
import simpletree.matrix.sparse.SparseVector;
import simpletree.model.content.LabelContent;
import simpletree.util.Util;

public class MatrixUtils {
    public static AbstractVector getRowById(int id, AbstractMatrix matrix) {
        AbstractVector foundVector = null;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            if (matrix.getRow(i).getId() != id) continue;
            foundVector = matrix.getRow(i);
            break;
        }
        return foundVector;
    }

    public static LabelContent getLabelContent(AbstractMatrix matrix) {
        ArrayList<String> labels = matrix.getLabels();
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        LabelContent labelContent = new LabelContent();
        ArrayList<Integer> ids = matrix.getIds();
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        for (int i = 0; i < ids.size(); ++i) {
            labelMap.put(ids.get(i), labels.get(i));
        }
        labelContent.setMap(labelMap);
        return labelContent;
    }

    public static AbstractVector mean(AbstractMatrix matrix) {
        assert (matrix.getRowCount() > 0) : "More than zero vectors must be used!";
        if (matrix instanceof SparseMatrix) {
            float[] mean = new float[matrix.getDimensions()];
            Arrays.fill(mean, 0.0f);
            int size = matrix.getRowCount();
            for (int i = 0; i < size; ++i) {
                int[] index = ((SparseVector)matrix.getRow(i)).getIndex();
                float[] values = matrix.getRow(i).getValues();
                for (int j = 0; j < index.length; ++j) {
                    int n = index[j];
                    mean[n] = mean[n] + values[j];
                }
            }
            for (int j = 0; j < mean.length; ++j) {
                mean[j] = mean[j] / (float)size;
            }
            return new SparseVector(mean);
        }
        if (matrix instanceof DenseMatrix) {
            float[] mean = new float[matrix.getDimensions()];
            Arrays.fill(mean, 0.0f);
            int size = matrix.getRowCount();
            for (int i = 0; i < size; ++i) {
                float[] values = matrix.getRow(i).getValues();
                for (int j = 0; j < values.length; ++j) {
                    int n = j;
                    mean[n] = mean[n] + values[j];
                }
            }
            for (int j = 0; j < mean.length; ++j) {
                mean[j] = mean[j] / (float)size;
            }
            return new DenseVector(mean);
        }
        return null;
    }

    public static SparseMatrix convert(DenseMatrix matrix) {
        SparseMatrix newmatrix = new SparseMatrix();
        newmatrix.setAttributes(matrix.getAttributes());
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            AbstractVector dv = matrix.getRow(i);
            newmatrix.addRow(new SparseVector(dv.toArray(), dv.getId(), dv.getKlass()));
        }
        return newmatrix;
    }

    public static DenseMatrix convert(SparseMatrix matrix) {
        DenseMatrix newmatrix = new DenseMatrix();
        newmatrix.setAttributes(matrix.getAttributes());
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            AbstractVector dv = matrix.getRow(i);
            newmatrix.addRow(new DenseVector(dv.toArray(), dv.getId(), dv.getKlass()));
        }
        return newmatrix;
    }

    public static ArrayList<ArrayList<Float>> getMinMax(AbstractMatrix matrix) {
        ArrayList<Float> min = new ArrayList<Float>();
        ArrayList<Float> max = new ArrayList<Float>();
        if (matrix.getDimensions() > 0) {
            float[] array = matrix.getRow(0).toArray();
            for (int j = 0; j < array.length; ++j) {
                min.add(Float.valueOf(array[j]));
                max.add(Float.valueOf(array[j]));
            }
            for (int i = 1; i < matrix.getRowCount(); ++i) {
                array = matrix.getRow(i).toArray();
                for (int j = 0; j < array.length; ++j) {
                    if (((Float)max.get(j)).floatValue() < array[j]) {
                        max.set(j, Float.valueOf(array[j]));
                        continue;
                    }
                    if (!(((Float)min.get(j)).floatValue() > array[j])) continue;
                    min.set(j, Float.valueOf(array[j]));
                }
            }
        }
        ArrayList<ArrayList<Float>> maxmin = new ArrayList<ArrayList<Float>>();
        maxmin.add(min);
        maxmin.add(max);
        return maxmin;
    }

    public static ArrayList<MinMax> getMinMax2(AbstractMatrix matrix) {
        ArrayList<MinMax> mm = new ArrayList<MinMax>();
        if (matrix.getDimensions() > 0) {
            int i;
            for (i = 0; i < matrix.getDimensions(); ++i) {
                mm.add(new MinMax());
            }
            for (i = 0; i < matrix.getRowCount(); ++i) {
                float[] array = matrix.getRow(i).toArray();
                for (int j = 0; j < array.length; ++j) {
                    if (mm.get((int)j).max < array[j]) {
                        mm.get((int)j).max = array[j];
                    }
                    if (!(mm.get((int)j).min > array[j])) continue;
                    mm.get((int)j).min = array[j];
                }
            }
        }
        return mm;
    }

    public static DenseMatrix transpose(AbstractMatrix matrix) {
        DenseMatrix newMatrix = new DenseMatrix();
        for (int i = 0; i < matrix.getDimensions(); ++i) {
            String id;
            float[] newVector = new float[matrix.getRowCount()];
            for (int j = 0; j < matrix.getRowCount(); ++j) {
                newVector[j] = matrix.getRow(j).getValue(i);
            }
            String string = id = matrix.getAttributes().size() > 0 ? matrix.getAttributes().get(i) : "";
            if (Util.isParsableToInt(id)) {
                newMatrix.addRow(new DenseVector(newVector, Integer.parseInt(id), 0.0f));
                continue;
            }
            newMatrix.addRow(new DenseVector(newVector, Util.convertToInt(id), 0.0f), id);
        }
        ArrayList<String> attributes = new ArrayList<String>();
        for (int j = 0; j < matrix.getRowCount(); ++j) {
            attributes.add(matrix.getLabel(j));
        }
        newMatrix.setAttributes(attributes);
        System.out.printf("newMatrix(%dx%d)\n", newMatrix.getRowCount(), newMatrix.getDimensions());
        return newMatrix;
    }

    public static void swapColumns(AbstractMatrix matrix, int c1, int c2) {
        try {
            if (c1 != c2) {
                assert (c1 < matrix.getDimensions() && c2 < matrix.getDimensions()) : "wrong index of Columns";
                Collections.swap(matrix.getAttributes(), c1, c2);
                for (int i = 0; i < matrix.getRowCount(); ++i) {
                    Float v1 = Float.valueOf(matrix.getRow(i).getValue(c1));
                    Float v2 = Float.valueOf(matrix.getRow(i).getValue(c2));
                    matrix.getRow(i).setValue(c1, v2.floatValue());
                    matrix.getRow(i).setValue(c2, v1.floatValue());
                }
            }
        }
        catch (Exception e) {
            System.out.printf("Exception: %s\n", e.toString());
        }
    }

    public static void swapRows(AbstractMatrix matrix, int row1, int row2) {
        AbstractVector vector1 = matrix.getRow(row1);
        String label1 = matrix.getLabel(row1);
        AbstractVector vector2 = matrix.getRow(row2);
        String label2 = matrix.getLabel(row2);
        matrix.getLabels().set(row2, label1);
        matrix.getLabels().set(row1, label2);
        matrix.setRow(row1, vector2);
        matrix.setRow(row2, vector1);
    }

    private static int lookForIndexInArray(int value, int[] anArray) {
        for (int i = 0; i < anArray.length; ++i) {
            if (anArray[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static void sortByDimension(AbstractMatrix matrix, int dimension) {
        int i;
        Float[][] valueAndIndex = new Float[matrix.getRowCount()][2];
        int[] oldOrder = new int[matrix.getRowCount()];
        for (i = 0; i < valueAndIndex.length; ++i) {
            valueAndIndex[i][0] = Float.valueOf(matrix.getRow(i).getValue(dimension));
            valueAndIndex[i][1] = new Float(i);
            oldOrder[i] = i;
        }
        Arrays.sort(valueAndIndex, new Comparator<Float[]>(){

            @Override
            public int compare(Float[] first, Float[] second) {
                return first[0].compareTo(second[0]);
            }
        });
        i = 0;
        while (i < valueAndIndex.length) {
            int r1 = MatrixUtils.lookForIndexInArray(valueAndIndex[i][1].intValue(), oldOrder);
            int r2 = i++;
            MatrixUtils.swapRows(matrix, r1, r2);
            int tempValue = oldOrder[r1];
            oldOrder[r1] = oldOrder[r2];
            oldOrder[r2] = tempValue;
        }
    }

    public static void sortByInstance(AbstractMatrix matrix, int instance) {
        int i;
        Float[][] valueAndIndex = new Float[matrix.getDimensions()][2];
        int[] oldOrder = new int[matrix.getDimensions()];
        for (i = 0; i < valueAndIndex.length; ++i) {
            valueAndIndex[i][0] = Float.valueOf(matrix.getRow(instance).getValue(i));
            valueAndIndex[i][1] = new Float(i);
            oldOrder[i] = i;
        }
        Arrays.sort(valueAndIndex, new Comparator<Float[]>(){

            @Override
            public int compare(Float[] first, Float[] second) {
                return first[0].compareTo(second[0]);
            }
        });
        i = 0;
        while (i < valueAndIndex.length) {
            int c1 = MatrixUtils.lookForIndexInArray(valueAndIndex[i][1].intValue(), oldOrder);
            int c2 = i++;
            MatrixUtils.swapColumns(matrix, c1, c2);
            int tempValue = oldOrder[c1];
            oldOrder[c1] = oldOrder[c2];
            oldOrder[c2] = tempValue;
        }
    }

    public static double[] getColumn(AbstractMatrix matrix, int column) {
        int numInstances = matrix.getRowCount();
        double[] aColumn = new double[numInstances];
        for (int i = 0; i < numInstances; ++i) {
            aColumn[i] = matrix.getRow(i).getValue(column);
        }
        return aColumn;
    }

    public static double[] getColumn(float[][] matrix, int column) {
        int numInstances = matrix.length;
        double[] aColumn = new double[numInstances];
        for (int i = 0; i < numInstances; ++i) {
            aColumn[i] = matrix[i][column];
        }
        return aColumn;
    }

    public static void reorder(AbstractMatrix matrix, int[] newOrderPositions) {
        assert (matrix.getRowCount() != newOrderPositions.length) : "Matrix and newOrderPositions must have the same size!";
        for (int i = 0; i < newOrderPositions.length - 1; ++i) {
            MatrixUtils.swapRows(matrix, i, newOrderPositions[i]);
        }
    }

    public static class MinMax {
        public float max = Float.NEGATIVE_INFINITY;
        public float min = Float.POSITIVE_INFINITY;
    }
}

