/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.writer;

import java.io.IOException;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.writer.BinaryMatrixWriter;
import simpletree.matrix.writer.BinaryMatrixWriterParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Points.Output", name="Binary points matrix writer", description="Write a Points Matrix to a binary file.")
public class BinaryMatrixWriterComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private transient BinaryMatrixWriterParamView paramview;
    private transient AbstractMatrix matrix;

    public void execute() throws IOException {
        if (this.filename.trim().length() <= 0) {
            throw new IOException("A matrix file name must be provided to write.");
        }
        BinaryMatrixWriter bmw = new BinaryMatrixWriter();
        bmw.write(this.matrix, this.filename);
    }

    public void input(@Param(name="matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new BinaryMatrixWriterParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.matrix = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

