/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.writer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import simpletree.matrix.writer.MatrixWriterComp;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.DATAFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class MatrixWriterParamView
extends AbstractParametersView {
    private MatrixWriterComp comp;
    private JButton matrixButton;
    private JLabel matrixLabel;
    private JTextField matrixTextField;

    public MatrixWriterParamView(MatrixWriterComp comp) {
        this.initComponents();
        this.comp = comp;
        this.reset();
    }

    private void initComponents() {
        this.matrixButton = new JButton();
        this.matrixTextField = new JTextField();
        this.matrixLabel = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder("Matrix Writer"));
        this.setLayout(new GridBagLayout());
        this.matrixButton.setText("Search...");
        this.matrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatrixWriterParamView.this.matrixButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.matrixButton, gridBagConstraints);
        this.matrixTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.matrixTextField, gridBagConstraints);
        this.matrixLabel.setText("File name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.matrixLabel, gridBagConstraints);
    }

    private void matrixButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            int result = SaveDialog.showSaveDialog(spm, new DATAFilter(), (Component)((Object)this), "matrix.data");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                this.matrixTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MatrixWriterParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reset() {
        this.matrixTextField.setText(this.comp.getFilename());
    }

    public void finished() throws IOException {
        if (this.matrixTextField.getText().trim().length() <= 0) {
            throw new IOException("A matrix file name must be provided.");
        }
        this.comp.setFilename(this.matrixTextField.getText());
    }
}

