/*
 * Decompiled with CFR 0.152.
 */
package simpletree.mesh;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mesh2d.basic.Cell;
import mesh2d.graph.Graph;
import simpletree.mesh.TreeVoronoi;
import simpletree.model.SimpleTreeModel;
import simpletree.model.content.AbstractContent;
import simpletree.model.content.ImageContent;
import simpletree.view.ProgressDialog;

public class TreeMosaic
extends TreeVoronoi {
    private final Map<Integer, List<Integer>> cellsIdsMap = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, Integer> activeIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Image> imageMap = new HashMap<Integer, Image>();
    private ProgressDialog progressDialog;

    public TreeMosaic(SimpleTreeModel model) {
        super(model);
    }

    public TreeMosaic(SimpleTreeModel model, Graph g) {
        super(model, g);
    }

    @Override
    public void build(Rectangle boundingBox) {
        super.build(boundingBox);
        if (this.model.getContent(AbstractContent.Type.IMAGE) == null) {
            return;
        }
        for (Cell cell : this.cellList) {
            int cellId = cell.getId();
            ArrayList<Integer> instancesInCell = this.instancesInCell(cell);
            this.cellsIdsMap.put(cellId, instancesInCell);
            if (!this.imageMap.containsKey(cellId)) {
                this.activeIndexMap.put(cellId, 0);
                ImageContent imageContent = (ImageContent)this.model.getContent(AbstractContent.Type.IMAGE);
                try {
                    Image im = imageContent.get((Integer)instancesInCell.get(0));
                    this.imageMap.put(cellId, im);
                    cell.setBackground(im);
                }
                catch (Exception ex) {
                    System.out.println("Error building Tree Mosaic!");
                    ex.printStackTrace();
                }
                continue;
            }
            Image im = this.imageMap.get(cellId);
            cell.setBackground(im);
        }
    }

    @Override
    public void paint(Graphics2D g2, boolean highQualityRender) {
        super.paint(g2, highQualityRender);
    }

    @Override
    public void scrollUp(Cell cell) {
        int cellId = cell.getId();
        int idIndex = this.activeIndexMap.get(cellId);
        List<Integer> cellIds = this.cellsIdsMap.get(cellId);
        ++idIndex;
        this.activeIndexMap.put(cellId, idIndex %= cellIds.size());
        ImageContent imageContent = (ImageContent)this.model.getContent(AbstractContent.Type.IMAGE);
        try {
            Image activeImage = imageContent.get(cellIds.get(this.activeIndexMap.get(cellId)));
            cell.setBackground(activeImage);
            this.imageMap.put(cell.getId(), activeImage);
        }
        catch (Exception ex) {
            System.err.printf("Error loading image for cell %d!\n", cell.getId());
            ex.printStackTrace();
        }
    }

    @Override
    public void scrollDown(Cell cell) {
        int cellId = cell.getId();
        int idIndex = this.activeIndexMap.get(cellId);
        List<Integer> cellIds = this.cellsIdsMap.get(cellId);
        if (--idIndex < 0) {
            idIndex = cellIds.size() - 1;
        }
        this.activeIndexMap.put(cellId, idIndex);
        try {
            ImageContent imageContent = (ImageContent)this.model.getContent(AbstractContent.Type.IMAGE);
            Image activeImage = imageContent.get(cellIds.get(this.activeIndexMap.get(cellId)));
            cell.setBackground(activeImage);
            this.imageMap.put(cell.getId(), activeImage);
        }
        catch (Exception ex) {
            System.err.printf("Error loading image for cell %d!\n", cell.getId());
            ex.printStackTrace();
        }
    }
}

