/*
 * Decompiled with CFR 0.152.
 */
package simpletree.mesh;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mesh2d.basic.Cell;
import mesh2d.graph.Graph;
import mesh2d.graph.Vertex;
import mesh2d.graph.util.GraphFilter;
import mesh2d.voronoi.VoronoiMesh;
import simpletree.basics.color.ColorTable;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.io.cluster.TreeCluster;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.Edge;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.content.AbstractContent;
import simpletree.model.content.LabelContent;

public class TreeVoronoi
extends VoronoiMesh {
    protected SimpleTreeModel model;
    protected BufferedImage image;
    protected Rectangle boundingBox;

    public TreeVoronoi(SimpleTreeModel model) {
        this.model = model;
        this.graph = TreeVoronoi.modelToGraph(model);
    }

    public TreeVoronoi(SimpleTreeModel model, Graph g) {
        this.model = model;
        this.graph = g;
    }

    public void scaleEuclidian(int distance) {
        this.graph = GraphFilter.euclidianFilter((Graph)this.graph, (float)distance);
    }

    public void updateGraph(SimpleTreeModel treeModel) {
        if (this.graph == null) {
            this.graph = TreeVoronoi.modelToGraph(treeModel);
            this.model = treeModel;
            return;
        }
        HashSet<Vertex> toRemove = new HashSet<Vertex>();
        for (Vertex v : this.graph.getVertices()) {
            SimpleTreeInstance inst = treeModel.getInstanceById(v.getId());
            if (inst != null) {
                v.setX((double)inst.getX());
                v.setY((double)inst.getY());
                v.setSelected(inst.isSelected());
                continue;
            }
            toRemove.add(v);
        }
        if (!toRemove.isEmpty()) {
            this.graph.getVertices().removeAll(toRemove);
            HashSet<mesh2d.graph.Edge> toRemoveEdge = new HashSet<mesh2d.graph.Edge>();
            for (mesh2d.graph.Edge e : this.graph.getEdges()) {
                if (!toRemove.contains(e.getSource()) && !toRemove.contains(e.getTarget())) continue;
                toRemoveEdge.add(e);
            }
            this.graph.getEdges().removeAll(toRemoveEdge);
        }
    }

    public void clearImage() {
        this.image = null;
    }

    public static final Graph modelToGraph(SimpleTreeModel treeModel) {
        ArrayList<Vertex> pointList = new ArrayList<Vertex>();
        for (AbstractInstance abInstance : treeModel.getInstances()) {
            SimpleTreeInstance treeInstance = (SimpleTreeInstance)abInstance;
            Vertex v = new Vertex(treeInstance.getId(), (double)treeInstance.getX(), (double)treeInstance.getY());
            v.setValid(treeInstance.isValid());
            v.setSelected(treeInstance.isSelected());
            pointList.add(v);
        }
        Graph newGraph = new Graph();
        newGraph.setVertices(pointList);
        float maxEdgeWeight = Float.MIN_VALUE;
        for (Edge e : treeModel.getSelectedConnectivity().getEdges()) {
            Vertex src = newGraph.getVertexById(e.getSource());
            Vertex tgt = newGraph.getVertexById(e.getTarget());
            mesh2d.graph.Edge newEdge = new mesh2d.graph.Edge(src, tgt, e.getWeight());
            newGraph.addEdge(newEdge);
            if (!(e.getWeight() > maxEdgeWeight)) continue;
            maxEdgeWeight = e.getWeight();
        }
        return newGraph;
    }

    protected ArrayList<Integer> instancesInCell(Cell cell) {
        ArrayList<Integer> intoCellList = new ArrayList<Integer>();
        for (AbstractInstance inst : this.model.getInstances()) {
            SimpleTreeInstance treeInst = (SimpleTreeInstance)inst;
            if (!treeInst.isValid() || !cell.contains((int)treeInst.getX(), (int)treeInst.getY())) continue;
            if (treeInst instanceof ClusterSimpleTreeInstance) {
                AbstractMatrix matrix = this.model.getMatrix();
                Cluster nodeCluster = ((ClusterSimpleTreeInstance)treeInst).getCluster();
                if (nodeCluster != null) {
                    intoCellList.addAll(this.getInstanceIds(nodeCluster.getMedoidList(), matrix));
                    continue;
                }
                TreeCluster treeCluster = ((ClusterSimpleTreeInstance)treeInst).getTreeCluster();
                if (treeCluster.getMedoidList().size() == 1) {
                    TreeCluster instanceCluster = null;
                    try {
                        instanceCluster = this.model.getSupertreeFile().Cluster.load(treeInst.getId());
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TreeVoronoi.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (instanceCluster != null) {
                        treeCluster = instanceCluster;
                        LabelContent modelLabels = (LabelContent)this.model.getContent(AbstractContent.Type.LABEL);
                        if (this.model.getSupertreeFile().Label.hasLabels()) {
                            List<String> labels;
                            try {
                                labels = this.model.getSupertreeFile().Label.getLabels();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(TreeVoronoi.class.getName()).log(Level.SEVERE, null, ex);
                                return null;
                            }
                            HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
                            for (int i = 0; i < labels.size(); ++i) {
                                labelMap.put(i, labels.get(i));
                            }
                            modelLabels = new LabelContent();
                            modelLabels.setMap(labelMap);
                        }
                        for (int medoidValue : treeCluster.getMedoidList()) {
                            try {
                                modelLabels.getMap().put(medoidValue, this.model.getSupertreeFile().Label.getById(medoidValue));
                            }
                            catch (IOException ex) {
                                Logger.getLogger(TreeVoronoi.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                intoCellList.addAll(treeCluster.getMedoidList());
                continue;
            }
            intoCellList.add(treeInst.getId());
        }
        return intoCellList;
    }

    protected List<Integer> getInstanceIds(List<Integer> elements, AbstractMatrix matrix) {
        ArrayList<Integer> elementsIds = new ArrayList<Integer>();
        for (Integer medoidRow : elements) {
            elementsIds.add(matrix.getRow(medoidRow).getId());
        }
        return elementsIds;
    }

    public void build(Rectangle boundingBox) {
        List allVertices = this.graph.getVertices();
        ArrayList<Vertex> validVertices = new ArrayList<Vertex>();
        this.boundingBox = boundingBox;
        for (Vertex v : allVertices) {
            if (!v.isValid()) continue;
            validVertices.add(v);
        }
        this.graph.setVertices(validVertices);
        super.build(boundingBox);
        this.graph.setVertices(allVertices);
        ColorTable colorTable = this.model.getColorTable();
        Scalar scalar = this.model.getSelectedScalar();
        for (Cell cell : this.cellList) {
            SimpleTreeInstance instance = this.model.getInstanceById(cell.getId());
            Color cellColor = this.getCellColor(instance.getScalarValue(scalar), scalar, colorTable);
            cell.setColor(cellColor);
            cell.setSelected(instance.isSelected());
        }
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        this.image = null;
    }

    public void setBackgroundAlpha(float backgroundAlpha) {
        this.backgroundAlpha = backgroundAlpha;
        this.image = null;
    }

    public void setEdgeAlpha(float edgeAlpha) {
        this.edgeAlpha = edgeAlpha;
        this.image = null;
    }

    public void paint(Graphics2D g2, boolean highQualityRender) {
        super.paint(g2, highQualityRender);
    }

    protected Color getCellColor(float cl, Scalar scalar, ColorTable colortable) {
        float value = 0.0f;
        if (scalar != null) {
            value = scalar.getMin() >= 0.0f && scalar.getMax() <= 1.0f ? cl : (cl - scalar.getMin()) / (scalar.getMax() - scalar.getMin());
        }
        return colortable.getColor(value);
    }

    public void scrollUp(Cell cell) {
    }

    public void scrollDown(Cell cell) {
    }
}

