/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Observable;
import java.util.Set;
import simpletree.model.AbstractInstance;
import simpletree.model.content.AbstractContent;

public abstract class AbstractModel
extends Observable {
    protected ArrayList<AbstractInstance> selinstances;
    protected ArrayList<AbstractInstance> instances = new ArrayList();
    protected Set<AbstractContent> contentSet;

    public AbstractModel() {
        this.selinstances = new ArrayList();
        this.contentSet = new HashSet<AbstractContent>();
    }

    public void addInstance(AbstractInstance instance) {
        instance.setModel(this);
        this.instances.add(instance);
        this.setChanged();
    }

    public ArrayList<AbstractInstance> getInstances() {
        return this.instances;
    }

    public void removeInstances(ArrayList<AbstractInstance> reminst) {
        HashSet<Integer> remids = new HashSet<Integer>();
        for (AbstractInstance ins : reminst) {
            if (ins.getModel() != this) continue;
            remids.add(ins.getId());
        }
        ArrayList<AbstractInstance> newins = new ArrayList<AbstractInstance>();
        for (int i = 0; i < this.instances.size(); ++i) {
            if (!remids.contains(this.instances.get(i).getId())) {
                newins.add(this.instances.get(i));
                continue;
            }
            this.instances.get(i).setModel(null);
        }
        this.instances = newins;
        this.setChanged();
    }

    public void removeSelectedInstances() {
        this.removeInstances(this.selinstances);
        this.selinstances = new ArrayList();
        this.setChanged();
    }

    public void cleanSelectedInstances() {
        for (AbstractInstance pi : this.selinstances) {
            pi.setSelected(false);
        }
        this.selinstances = new ArrayList();
        this.setChanged();
    }

    public void setSelectedInstances(ArrayList<AbstractInstance> selinst) {
        if (selinst != null) {
            this.cleanSelectedInstances();
            this.selinstances = new ArrayList();
            for (AbstractInstance pi : selinst) {
                if (pi.getModel() != this) continue;
                pi.setSelected(true);
                this.selinstances.add(pi);
            }
            this.setChanged();
        }
    }

    public void setSelectedInstance(AbstractInstance selinst) {
        if (selinst != null) {
            this.cleanSelectedInstances();
            if (selinst.getModel() == this) {
                selinst.setSelected(true);
                this.selinstances.add(selinst);
            }
            this.setChanged();
        }
    }

    public boolean hasSelectedInstances() {
        return this.selinstances.size() > 0;
    }

    public ArrayList<AbstractInstance> getSelectedInstances() {
        return this.selinstances;
    }

    @Override
    public void setChanged() {
        super.setChanged();
    }

    public boolean addContent(AbstractContent newContent) {
        if (newContent != null) {
            return this.contentSet.add(newContent);
        }
        return false;
    }

    public AbstractContent getContent(AbstractContent.Type type) {
        for (AbstractContent content : this.contentSet) {
            if (!content.getType().equals((Object)type)) continue;
            return content;
        }
        return null;
    }

    public boolean removeContent(AbstractContent content) {
        return this.contentSet.remove(content);
    }
}

