/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import simpletree.basics.ClusterContentSimpleTree;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.SimpleTree;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.io.cluster.TreeCluster;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;

public class ClusterSimpleTreeInstance
extends SimpleTreeInstance {
    private SimpleTree clusterTree;
    private Cluster cluster;
    private TreeCluster treeCluster;
    public boolean manuallyCreated = false;
    private int levelHeight = 0;

    @Override
    public ClusterSimpleTreeInstance createClone(SimpleTreeModel model) {
        Scalar selscalar = model.getSelectedScalar();
        ClusterSimpleTreeInstance ins = new ClusterSimpleTreeInstance(model, this.id, this.isValid());
        ins.setColor(this.getColor());
        ins.setParent(this.getParent());
        ins.setScalarValue(selscalar, this.getScalarValue(selscalar));
        ins.setSelected(this.isSelected());
        ins.setShowLabel(this.isShowLabel());
        ins.setSizeFactor(this.getSizeFactor());
        ins.setX(this.getX());
        ins.setY(this.getY());
        ins.fdata = this.fdata;
        ins.scalars = new ArrayList();
        for (int i = 0; i < this.scalars.size(); ++i) {
            ins.scalars.add(this.scalars.get(i));
        }
        ins.setChildren(this.copyChildren());
        ins.setParent(this.getParent());
        ins.setClusterTree(this.clusterTree);
        ins.setCluster(this.cluster);
        return ins;
    }

    public ClusterSimpleTreeInstance(SimpleTreeModel model, int id, float x, float y, boolean valid, SimpleTree clusterTree) {
        super(model, id, x, y, valid);
        this.clusterTree = clusterTree;
    }

    public ClusterSimpleTreeInstance(SimpleTreeModel model, Cluster cluster, int id, float x, float y, boolean valid) {
        super(model, id, x, y, valid);
        this.cluster = cluster;
    }

    public ClusterSimpleTreeInstance(SimpleTreeModel model, TreeCluster treeCluster, int id, float x, float y, boolean valid) {
        super(model, id, x, y, valid);
        this.treeCluster = treeCluster;
    }

    public ClusterSimpleTreeInstance(SimpleTreeModel model, int id, boolean valid) {
        this(model, id, 0.0f, 0.0f, valid, null);
    }

    public ClusterSimpleTreeInstance(SimpleTreeModel model, int id) {
        this(model, id, 0.0f, 0.0f, false, null);
    }

    @Override
    public String toString() {
        return "Node Id: " + Integer.toString(this.id);
    }

    @Override
    public boolean isInside(int x, int y) {
        SimpleTreeModel tmodel = (SimpleTreeModel)this.model;
        return Math.sqrt(Math.pow((float)x - this.x, 2.0) + Math.pow((float)y - this.y, 2.0)) <= (double)(tmodel.getInstanceSize() * 2);
    }

    @Override
    public void draw(Graphics2D g2, boolean highquality) {
        int xaux;
        SimpleTreeModel tmodel = (SimpleTreeModel)this.model;
        Rectangle boundingBox = new Rectangle(tmodel.getSize());
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int n = (int)this.x <= 0 ? 1 : (xaux = (int)this.x < (int)boundingBox.getWidth() ? (int)this.x : (int)boundingBox.getWidth() - 1);
        int yaux = (int)this.y <= 0 ? 1 : ((int)this.y < (int)boundingBox.getHeight() ? (int)this.y : (int)boundingBox.getHeight() - 1);
        int inssize = tmodel.getInstanceSize() * 2;
        float alpha = tmodel.getAlpha();
        if (tmodel.getSelectedInstances() == null || tmodel.getSelectedInstances().isEmpty() || tmodel.isNoAlpha()) {
            alpha = 1.0f;
        }
        if (((SimpleTreeModel)this.model).isDrawAsImage()) {
            Image rimg;
            if (((SimpleTreeModel)this.model).getImages() != null && (rimg = ((SimpleTreeModel)this.model).getImages().get(this.getMedoidId())) != null) {
                int imgSize = tmodel.getImagesSize();
                Image img = rimg.getScaledInstance(imgSize * 10, imgSize * 10, 0);
                int w = img.getWidth(null);
                int h = img.getHeight(null);
                g2.drawImage(img, xaux - w / 2, yaux - h / 2, null);
                if (((SimpleTreeModel)this.model).isDrawImageFrame()) {
                    g2.setStroke(new BasicStroke(3.0f));
                    g2.setColor(this.getColor());
                    g2.drawRect(xaux - w / 2 - 2, yaux - h / 2 - 2, w + 3, h + 3);
                    g2.setStroke(new BasicStroke(1.0f));
                }
                if (this.selected) {
                    g2.setStroke(new BasicStroke(2.0f));
                    g2.setColor(Color.RED);
                    g2.drawRect((int)this.x - w / 2, (int)this.y - h / 2, w, h);
                    g2.setStroke(new BasicStroke(1.0f));
                }
            }
        } else {
            if (this.selected || !this.isValid()) {
                alpha = 1.0f;
            }
            if (this.isValid()) {
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                if (this.manuallyCreated) {
                    g2.setColor(Color.WHITE);
                } else {
                    g2.setColor(this.color);
                }
                g2.fillOval(xaux - inssize, yaux - inssize, inssize * 2, inssize * 2);
                g2.setColor(Color.BLACK);
                g2.drawOval(xaux - inssize, yaux - inssize, inssize * 2, inssize * 2);
            } else {
                g2.setColor(Color.WHITE);
                g2.fillOval(xaux - (inssize /= 2), yaux - inssize, inssize * 2, inssize * 2);
                g2.setColor(Color.GRAY);
                g2.drawOval(xaux - inssize, yaux - inssize, inssize * 2, inssize * 2);
            }
            g2.setStroke(new BasicStroke(1.0f));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    @Override
    public void draw(BufferedImage image, boolean highquality) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        this.draw(g2, highquality);
    }

    public SimpleTree getClusterTree() {
        return this.clusterTree;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public int getLevelHeight() {
        return this.levelHeight;
    }

    public void setLevelHeight(int levelHeight) {
        this.levelHeight = levelHeight;
    }

    private int searchMedoidId(ContentSimpleTree node, SimpleTree nodeClusterTree) {
        if (node instanceof ClusterContentSimpleTree) {
            SimpleTree newClusterTree = ((ClusterContentSimpleTree)node).getTree();
            return this.searchMedoidId(newClusterTree.getNodeById(newClusterTree.getRootId()), newClusterTree);
        }
        if (!node.isValid()) {
            return this.searchMedoidId(nodeClusterTree.getNodeById(node.getChildrenId(0)), nodeClusterTree);
        }
        return node.getId();
    }

    public int getMedoidId() {
        int medoidId = -1;
        if (this.cluster != null && ((SimpleTreeModel)this.model).getMatrix() != null) {
            int matrixRow = this.cluster.getMedoidList().get(0);
            medoidId = ((SimpleTreeModel)this.model).getMatrix().getRow(matrixRow).getId();
        } else if (this.treeCluster != null) {
            int n = this.treeCluster.getMedoidList().get(0);
        }
        return medoidId;
    }

    public ClusterSimpleTreeInstance(int id, float x, float y, boolean valid, SimpleTree clusterTree) {
        super(id, x, y, valid);
        this.clusterTree = clusterTree;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public void setClusterTree(SimpleTree clusterTree) {
        this.clusterTree = clusterTree;
    }

    public TreeCluster getTreeCluster() {
        return this.treeCluster;
    }

    public void setTreeCluster(TreeCluster treeCluster) {
        this.treeCluster = treeCluster;
    }
}

