/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.GraphInstance;
import simpletree.model.GraphModel;
import simpletree.model.Scalar;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Graph.Basics", name="Graph Model", description="Create a graph model to be visualized.")
public class GraphModelComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient GraphModel model;
    private transient AbstractMatrix placement;
    private transient ArrayList<Connectivity> conns;

    public void execute() throws IOException {
        if (this.placement != null) {
            this.model = new GraphModel();
            Scalar cdata = this.model.addScalar("cdata");
            Scalar dots = this.model.addScalar("...");
            int nrows = this.placement.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                AbstractVector row = this.placement.getRow(i);
                GraphInstance pi = new GraphInstance(row.getId(), row.getValue(0), row.getValue(1));
                this.model.addInstance(pi);
                pi.setScalarValue(cdata, row.getKlass());
                pi.setScalarValue(dots, 0.0f);
            }
            Connectivity dotsCon = new Connectivity("...", new ArrayList<Edge>());
            this.model.addConnectivity(dotsCon);
            for (int i = 0; i < this.conns.size(); ++i) {
                this.model.addConnectivity(this.conns.get(i));
            }
        } else {
            throw new IOException("A 2D position should be provided.");
        }
    }

    public void input(@Param(name="2D placement") AbstractMatrix placement) {
        this.placement = placement;
    }

    public void attach(@Param(name="connectivity") Connectivity conn) {
        if (this.conns == null) {
            this.conns = new ArrayList();
        }
        if (conn != null) {
            this.conns.add(conn);
        }
    }

    public GraphModel output() {
        return this.model;
    }

    public AbstractParametersView getParametersEditor() {
        return null;
    }

    public void reset() {
        this.placement = null;
        this.model = null;
        this.conns = null;
    }
}

