/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import simpletree.basics.color.ColorTable;
import simpletree.model.AbstractInstance;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.ProjectionInstance;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeConnectivity;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;

public class PartialTreeModel
extends SimpleTreeModel {
    private boolean partialTreeDraw = false;
    private ArrayList<AbstractInstance> partialTreeVisibleNodes;
    private ArrayList<AbstractInstance> partialTreeBorderNodes;
    private AbstractInstance partialTreeRootNode;
    private float partialTreeMarkOpacity = 0.8f;
    private int partialTreeLevels = 5;
    private Point translationOffset;

    public PartialTreeModel(SimpleTreeModel treeModel) {
        this.instances = new ArrayList();
        for (AbstractInstance modelInstance : treeModel.getInstances()) {
            ((SimpleTreeInstance)modelInstance).createClone(this);
        }
        this.connectivities = new ArrayList();
        for (Connectivity connectivitie : this.connectivities) {
            ArrayList<Edge> edges = new ArrayList<Edge>();
            for (int j = 0; j < connectivitie.getEdges().size(); ++j) {
                edges.add(new Edge(connectivitie.getEdges().get(j).getSource(), connectivitie.getEdges().get(j).getTarget()));
            }
            SimpleTreeConnectivity conn = new SimpleTreeConnectivity(connectivitie.getName(), edges);
            this.connectivities.add(conn);
        }
        this.scalars = new ArrayList();
        for (Scalar scalar : treeModel.getScalars()) {
            Scalar newScalar = new Scalar(scalar.getName());
            newScalar.store(scalar.getMin());
            newScalar.store(scalar.getMax());
            this.scalars.add(newScalar);
        }
        int i = 0;
        if (this.selsconn != null) {
            i = this.connectivities.indexOf(this.selsconn);
            if (i != -1) {
                this.selsconn = (SimpleTreeConnectivity)this.connectivities.get(i);
            }
        } else {
            this.selsconn = null;
        }
        this.setInstanceSize(treeModel.getInstanceSize());
        this.colortable = new ColorTable(treeModel.getColorTable().getColorScaleType());
        this.alpha = treeModel.getAlpha();
        this.setRoot(treeModel.getRoot());
        this.setType(treeModel.getType());
        this.selscalar = treeModel.getSelectedScalar();
        this.setInstanceSize(treeModel.getInstanceSize());
    }

    public int getPartialTreeLevels() {
        return this.partialTreeLevels;
    }

    public void setPartialTreeLevels(int partialTreeLevels) {
        this.partialTreeLevels = partialTreeLevels;
    }

    public boolean isPartialTreeDraw() {
        return this.partialTreeDraw;
    }

    public void setPartialTreeDraw(boolean partialTreeDraw) {
        this.partialTreeDraw = partialTreeDraw;
    }

    public ArrayList<AbstractInstance> getPartialTreeVisibleNodes() {
        return this.partialTreeVisibleNodes;
    }

    public void setPartialTreeVisibleNodes(ArrayList<AbstractInstance> partialTreeVisibleNodes) {
        this.partialTreeVisibleNodes = partialTreeVisibleNodes;
    }

    public ArrayList<AbstractInstance> getPartialTreeBorderNodes() {
        return this.partialTreeBorderNodes;
    }

    public void setPartialTreeBorderNodes(ArrayList<AbstractInstance> partialTreeBorderNodes) {
        this.partialTreeBorderNodes = partialTreeBorderNodes;
    }

    public AbstractInstance getPartialTreeRootNode() {
        return this.partialTreeRootNode;
    }

    public void setPartialTreeRootNode(AbstractInstance partialTreeRootNode) {
        this.partialTreeRootNode = partialTreeRootNode;
    }

    public Point getTranslationOffset() {
        return this.translationOffset;
    }

    public float getPartialTreeMarkOpacity() {
        return this.partialTreeMarkOpacity;
    }

    public void setPartialTreeMarkOpacity(float partialTreeMarkOpacity) {
        this.partialTreeMarkOpacity = partialTreeMarkOpacity;
    }

    public void setTranslationOffset(Point translationOffset) {
        this.translationOffset = translationOffset;
    }

    @Override
    public SimpleTreeInstance getInstanceByPosition(Point point) {
        ArrayList<AbstractInstance> searchInstances = new ArrayList<AbstractInstance>();
        searchInstances.addAll(this.partialTreeVisibleNodes);
        searchInstances.addAll(this.partialTreeBorderNodes);
        for (AbstractInstance searchInstance : searchInstances) {
            SimpleTreeInstance pi = (SimpleTreeInstance)searchInstance;
            if (!pi.isInside(point.x - this.translationOffset.x, point.y - this.translationOffset.y)) continue;
            return pi;
        }
        return null;
    }

    @Override
    public ArrayList<ProjectionInstance> getInstancesByPosition(Rectangle rect) {
        ArrayList<ProjectionInstance> selected = new ArrayList<ProjectionInstance>();
        rect.translate(-this.translationOffset.x, -this.translationOffset.y);
        ArrayList<AbstractInstance> visibleNodes = new ArrayList<AbstractInstance>();
        visibleNodes.addAll(this.partialTreeVisibleNodes);
        visibleNodes.addAll(this.partialTreeBorderNodes);
        for (AbstractInstance visibleNode : visibleNodes) {
            ProjectionInstance pi = (ProjectionInstance)visibleNode;
            if (!pi.isInside(rect)) continue;
            selected.add(pi);
        }
        return selected;
    }

    @Override
    public ArrayList<ProjectionInstance> getInstancesByPosition(Polygon polygon) {
        ArrayList<ProjectionInstance> selected = new ArrayList<ProjectionInstance>();
        polygon.translate(-this.translationOffset.x, -this.translationOffset.y);
        ArrayList<AbstractInstance> visibleNodes = new ArrayList<AbstractInstance>();
        visibleNodes.addAll(this.partialTreeVisibleNodes);
        visibleNodes.addAll(this.partialTreeBorderNodes);
        for (AbstractInstance visibleNode : visibleNodes) {
            ProjectionInstance pi = (ProjectionInstance)visibleNode;
            if (!polygon.contains(pi.getX(), pi.getY())) continue;
            selected.add(pi);
        }
        return selected;
    }

    @Override
    public void draw(BufferedImage image, boolean highquality) {
        SimpleTreeInstance gi;
        int i;
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        ArrayList<AbstractInstance> validNodes = new ArrayList<AbstractInstance>();
        validNodes.addAll(this.partialTreeVisibleNodes);
        validNodes.addAll(this.partialTreeBorderNodes);
        if (this.selsconn != null) {
            ((SimpleTreeConnectivity)this.selsconn).draw(this, image, highquality, validNodes);
        }
        for (int i2 = 0; i2 < this.getPartialTreeVisibleNodes().size(); ++i2) {
            SimpleTreeInstance gi2 = (SimpleTreeInstance)this.getPartialTreeVisibleNodes().get(i2);
            if (gi2.isValid()) continue;
            gi2.draw(image, highquality);
        }
        int maxDeepChildrenCount = Integer.MIN_VALUE;
        for (AbstractInstance borderInstance : this.getPartialTreeBorderNodes()) {
            if (maxDeepChildrenCount >= ((SimpleTreeInstance)borderInstance).getRecursiveChildCount()) continue;
            maxDeepChildrenCount = ((SimpleTreeInstance)borderInstance).getRecursiveChildCount();
        }
        for (i = 0; i < this.getPartialTreeBorderNodes().size(); ++i) {
            gi = (SimpleTreeInstance)this.getPartialTreeBorderNodes().get(i);
            gi.draw(image, highquality);
            if (gi.getRecursiveChildCount() <= 0) continue;
            gi.drawMark(g2, highquality, (double)gi.getRecursiveChildCount() / (double)maxDeepChildrenCount, false, 0.0f);
        }
        for (i = 0; i < this.getPartialTreeVisibleNodes().size(); ++i) {
            gi = (SimpleTreeInstance)this.getPartialTreeVisibleNodes().get(i);
            if (!gi.isValid()) continue;
            gi.draw(image, highquality);
        }
        ((SimpleTreeInstance)this.getPartialTreeRootNode()).drawMark(g2, highquality, 1.0, true, this.partialTreeMarkOpacity);
    }

    @Override
    public Rectangle getImagePosition() {
        ArrayList<AbstractInstance> instanceList = new ArrayList<AbstractInstance>();
        instanceList.addAll(this.partialTreeBorderNodes);
        instanceList.addAll(this.partialTreeVisibleNodes);
        float maxX = Float.MIN_VALUE;
        float minX = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        for (AbstractInstance instance : instanceList) {
            SimpleTreeInstance treeInstance = (SimpleTreeInstance)instance;
            if (maxX < treeInstance.getX()) {
                maxX = treeInstance.getX();
            }
            if (minX > treeInstance.getX()) {
                minX = treeInstance.getX();
            }
            if (maxY < treeInstance.getY()) {
                maxY = treeInstance.getY();
            }
            if (!(minY > treeInstance.getY())) continue;
            minY = treeInstance.getY();
        }
        return new Rectangle((int)minX, (int)minY, (int)maxX - (int)minX, (int)maxY - (int)minY);
    }
}

