/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;

public class ProjectionInstance
extends AbstractInstance {
    protected ArrayList<Float> scalars;
    protected float x;
    protected float y;
    protected boolean showlabel;
    protected Color color;

    public ProjectionInstance(int id, float x, float y) {
        super(id);
        this.x = x;
        this.y = y;
        this.scalars = new ArrayList();
        this.showlabel = false;
        this.color = Color.BLACK;
    }

    public ProjectionInstance(int id) {
        this(id, 0.0f, 0.0f);
    }

    public void draw(BufferedImage image, boolean highquality) {
        int yaux;
        int xaux;
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int n = (int)this.x <= 0 ? 1 : (xaux = (int)this.x < image.getWidth() ? (int)this.x : image.getWidth() - 1);
        int n2 = (int)this.y <= 0 ? 1 : (yaux = (int)this.y < image.getHeight() ? (int)this.y : image.getHeight() - 1);
        if (this.selected) {
            int rgbcolor = this.color.getRGB();
            image.setRGB(xaux - 1, yaux - 1, rgbcolor);
            image.setRGB(xaux, yaux - 1, rgbcolor);
            image.setRGB(xaux + 1, yaux - 1, rgbcolor);
            image.setRGB(xaux - 1, yaux, rgbcolor);
            image.setRGB(xaux, yaux, rgbcolor);
            image.setRGB(xaux + 1, yaux, rgbcolor);
            image.setRGB(xaux - 1, yaux + 1, rgbcolor);
            image.setRGB(xaux, yaux + 1, rgbcolor);
            image.setRGB(xaux + 1, yaux + 1, rgbcolor);
            g2.setColor(Color.GRAY);
            g2.drawRect(xaux - 2, yaux - 2, 4, 4);
        } else {
            int rgb = this.color.getRGB();
            float alpha = ((ProjectionModel)this.model).getAlpha();
            this.simulateAlpha(image, alpha, xaux - 1, yaux - 1, rgb);
            this.simulateAlpha(image, alpha, xaux, yaux - 1, rgb);
            this.simulateAlpha(image, alpha, xaux + 1, yaux - 1, rgb);
            this.simulateAlpha(image, alpha, xaux - 1, yaux, rgb);
            this.simulateAlpha(image, alpha, xaux, yaux, rgb);
            this.simulateAlpha(image, alpha, xaux + 1, yaux, rgb);
            this.simulateAlpha(image, alpha, xaux - 1, yaux + 1, rgb);
            this.simulateAlpha(image, alpha, xaux, yaux + 1, rgb);
            this.simulateAlpha(image, alpha, xaux + 1, yaux + 1, rgb);
        }
        if (this.showlabel) {
            this.drawLabel(g2, xaux, yaux);
        }
    }

    public void drawLabel(Graphics2D g2, int x, int y) {
        String label = this.toString().trim();
        if (label.trim().length() > 0 && label.length() > 100) {
            label = label.substring(0, 96) + "...";
        }
        FontMetrics metrics = g2.getFontMetrics(g2.getFont());
        int width = metrics.stringWidth(label);
        int height = metrics.getAscent();
        g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
        g2.setPaint(Color.WHITE);
        g2.fillRect(x + 3, y - 1 - height, width + 4, height + 4);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setColor(Color.DARK_GRAY);
        g2.drawRect(x + 3, y - 1 - height, width + 4, height + 4);
        g2.drawString(label, x + 3, y);
    }

    public boolean isInside(int x, int y) {
        return Math.abs(this.x - (float)x) <= 1.0f && Math.abs(this.y - (float)y) <= 1.0f;
    }

    public boolean isInside(Rectangle rect) {
        return this.x >= (float)rect.x && this.x - (float)rect.x < (float)rect.width && this.y >= (float)rect.y && this.y - (float)rect.y < (float)rect.height;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
        if (this.model != null) {
            this.model.setChanged();
        }
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
        if (this.model != null) {
            this.model.setChanged();
        }
    }

    public boolean isShowLabel() {
        return this.showlabel;
    }

    public void setShowLabel(boolean showlabel) {
        this.showlabel = showlabel;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setScalarValue(Scalar scalar, float value) {
        if (this.model == null) {
            throw new NullPointerException("This instance should be added to a model before using this method!");
        }
        if (scalar != null) {
            int index = ((ProjectionModel)this.model).getScalars().indexOf(scalar);
            if (this.scalars.size() > index) {
                this.scalars.set(index, Float.valueOf(value));
            } else {
                int size = this.scalars.size();
                for (int i = 0; i < index - size; ++i) {
                    this.scalars.add(Float.valueOf(0.0f));
                }
                this.scalars.add(Float.valueOf(value));
            }
            scalar.store(value);
        }
    }

    public float getScalarValue(Scalar scalar) {
        if (this.model == null) {
            throw new NullPointerException("This instance should be added to a model before using this method!");
        }
        if (scalar != null) {
            int index = ((ProjectionModel)this.model).getScalars().indexOf(scalar);
            if (this.scalars.size() > index && index > -1) {
                return this.scalars.get(index).floatValue();
            }
        }
        return 0.0f;
    }

    public float getNormalizedScalarValue(Scalar scalar) {
        if (this.model == null) {
            throw new NullPointerException("This instance should be added to a model before using this method!");
        }
        if (scalar != null) {
            int index = ((ProjectionModel)this.model).getScalars().indexOf(scalar);
            if (this.scalars.size() > index && index > -1) {
                float value = this.scalars.get(index).floatValue();
                return (value - scalar.getMin()) / (scalar.getMax() - scalar.getMin());
            }
        }
        return 0.0f;
    }

    protected void simulateAlpha(BufferedImage image, float alpha, int x, int y, int rgb) {
        try {
            int oldrgb = image.getRGB(x, y);
            int oldr = oldrgb >> 16 & 0xFF;
            int oldg = oldrgb >> 8 & 0xFF;
            int oldb = oldrgb & 0xFF;
            int newr = (int)(alpha * (float)((rgb >> 16 & 0xFF) - oldr) + (float)oldr);
            int newg = (int)(alpha * (float)((rgb >> 8 & 0xFF) - oldg) + (float)oldg);
            int newb = (int)(alpha * (float)((rgb & 0xFF) - oldb) + (float)oldb);
            int newrgb = newb | newg << 8 | newr << 16;
            image.setRGB(x, y, newrgb);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.out.println(x + "," + y);
        }
    }
}

