/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import simpletree.basics.ClusterContentSimpleTree;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.MultiscaleParams;
import simpletree.basics.SimpleTree;
import simpletree.basics.color.ColorTable;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.file.SupertreeFile;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.GraphModel;
import simpletree.model.ProjectionInstance;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeConnectivity;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.content.AbstractContent;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.util.ImageCollection;
import simpletree.util.PseudoClass;
import simpletree.util.TablePScalar;

public class SimpleTreeModel
extends GraphModel
implements Serializable {
    private HashMap<Integer, Float> classMap;
    private int multiScaleLevel;
    private int highLightInstanceId = -1;
    private boolean showInstancesVoronoi = true;
    private MultiscaleParams multiscaleParams;
    private AbstractMatrix matrix;
    private static final Logger logger = Logger.getLogger(SimpleTreeModel.class.getName());
    private AbstractContent modelContent;
    private SupertreeFile stFile;
    private List<Integer> subTreeIds = new ArrayList<Integer>();
    private Corpus corpus;
    protected TablePScalar tablePScalar;
    public static final long serialVersionUID = 1L;
    private int root;
    private String type;
    private boolean noAlpha;
    private boolean drawAsImage = false;
    private boolean drawImageFrame = false;
    private String imageCollectionPath = null;
    private HashMap<Integer, String> labels;
    private HashMap<Integer, Image> images;
    private int imagesSize = 4;
    protected String source = "";

    public SimpleTreeModel() {
        this.alpha = 0.2f;
        this.noAlpha = false;
    }

    public SimpleTreeModel(SimpleTree tree) {
        this();
        this.multiscaleParams = tree.getMultiScaleParams();
        Scalar cdata = this.addScalar("cdata");
        Scalar dots = this.addScalar("...");
        HashMap<Integer, Integer> ids = new HashMap<Integer, Integer>();
        float maxScalarValue = Float.MIN_VALUE;
        float minScalarValue = Float.MAX_VALUE;
        for (int i = 0; i < tree.getSize(); ++i) {
            ContentSimpleTree node = tree.getNode(i);
            if (node == null) continue;
            SimpleTreeInstance ti = null;
            if (node instanceof ClusterContentSimpleTree) {
                SimpleTree clusterTree = ((ClusterContentSimpleTree)node).getTree();
                Cluster nodeCluster = ((ClusterContentSimpleTree)node).getCluster();
                TreeCluster treeCluster = ((ClusterContentSimpleTree)node).getTreeCluster();
                if (clusterTree != null) {
                    ti = new ClusterSimpleTreeInstance(this, node.getId(), 0.0f, 0.0f, node.isValid(), ((ClusterContentSimpleTree)node).getTree());
                } else if (nodeCluster != null) {
                    ti = new ClusterSimpleTreeInstance(this, nodeCluster, node.getId(), 0.0f, 0.0f, node.isValid());
                } else if (treeCluster != null) {
                    ti = new ClusterSimpleTreeInstance(this, treeCluster, node.getId(), 0.0f, 0.0f, node.isValid());
                }
                ((ClusterSimpleTreeInstance)ti).setLevelHeight(((ClusterContentSimpleTree)node).getLevelHeight());
                ((ClusterSimpleTreeInstance)ti).manuallyCreated = ((ClusterContentSimpleTree)node).manuallyCreated;
            } else {
                ti = new SimpleTreeInstance(this, node.getId(), 0.0f, 0.0f, node.isValid());
            }
            ids.put(ti.getId(), this.getInstances().indexOf(ti));
            ti.setScalarValue(cdata, node.getKlass());
            ti.setScalarValue(dots, 0.0f);
            if (node.getKlass() > maxScalarValue) {
                maxScalarValue = node.getKlass();
            }
            if (node.getKlass() < minScalarValue) {
                minScalarValue = node.getKlass();
            }
            float distChild = 0.0f;
            for (int j = 0; j < node.getNumChildren(); ++j) {
                ti.setChildrenId(j, node.getChildrenId(j));
                distChild = node.getDistChildren(j);
                ti.setChildrenDist(j, distChild);
            }
            ti.setParent(node.getParent());
            ti.setRecursiveChildCount(node.getRecursiveChildCount());
            ti.level = node.getLevel();
            ti.multiscaleLevel = node.multiscaleLevel;
        }
        cdata = this.getScalarByName("cdata");
        cdata.setMin(minScalarValue);
        cdata.setMax(maxScalarValue);
        this.root = tree.getRootId();
        SimpleTreeConnectivity dotsCon = new SimpleTreeConnectivity("...", new ArrayList<Edge>());
        this.addConnectivity(dotsCon);
        ArrayList<Edge> edges = tree.getEdges();
        if (edges != null) {
            SimpleTreeConnectivity nj = new SimpleTreeConnectivity("Neighbor-Joinning", edges);
            this.addConnectivity(nj);
        }
        if (this.getConnectivities().size() > 1) {
            this.setSelectedConnectivity(this.getConnectivities().get(1));
        }
        Collections.sort(this.instances, new Comparator(){

            public int compare(Object o1, Object o2) {
                SimpleTreeInstance st1 = (SimpleTreeInstance)o1;
                SimpleTreeInstance st2 = (SimpleTreeInstance)o2;
                return Integer.compare(st1.getId(), st2.getId());
            }
        });
        this.type = tree.getType();
        if (this.type == null) {
            this.type = "Neighbor-Joinning";
        }
    }

    public SimpleTreeModel(AbstractMatrix placement, ArrayList<SimpleTreeConnectivity> conns, String collection) {
        this();
        Scalar cdata = this.addScalar("cdata");
        Scalar dots = this.addScalar("...");
        HashMap<Integer, Integer> ids = new HashMap<Integer, Integer>();
        int nrows = placement.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            AbstractVector row = placement.getRow(i);
            SimpleTreeInstance pi = new SimpleTreeInstance(this, row.getId(), row.getValue(0), row.getValue(1), true);
            ids.put(pi.getId(), this.instances.indexOf(pi));
            pi.setScalarValue(cdata, row.getKlass());
            pi.setScalarValue(dots, 0.0f);
        }
        SimpleTreeConnectivity dotsCon = new SimpleTreeConnectivity("...", new ArrayList<Edge>());
        this.addConnectivity(dotsCon);
        if (conns != null) {
            for (int i = 0; i < conns.size(); ++i) {
                this.addConnectivity(conns.get(i));
            }
        }
        if (this.getConnectivities().size() > 1) {
            this.setSelectedConnectivity(this.getConnectivities().get(1));
        }
        this.type = this.getSelectedConnectivity() != null ? this.getSelectedConnectivity().getName() : "Neighbor-Joinning";
    }

    public void appendTree(SimpleTreeModel refTreeModel, int intoNodeId, boolean checkDuplicates) {
        SimpleTreeInstance intoInstance = this.getInstanceById(intoNodeId);
        SimpleTreeInstance refRootInstance = refTreeModel.getInstanceById(refTreeModel.getRoot());
        if (checkDuplicates) {
            for (AbstractInstance instance : refTreeModel.instances) {
                SimpleTreeInstance refTreeInstance = (SimpleTreeInstance)instance;
                if (this.getInstanceById(refTreeInstance.getId()) == null) continue;
                logger.log(Level.WARNING, "Adding a duplicate id instance: {0}!", refTreeInstance.getId());
            }
        }
        SimpleTreeInstance parentInstance = this.getInstanceById(intoInstance.getParent());
        for (int i = 0; i < parentInstance.getNumChildren(); ++i) {
            int childId = parentInstance.getChildrenId(i);
            if (childId != intoInstance.getId()) continue;
            parentInstance.setChildrenId(i, refRootInstance.getId());
            break;
        }
        refRootInstance.setParent(parentInstance.getId());
        Connectivity njConn = this.getConnectivityByName("Neighbor-Joinning");
        float oldEdgeWeight = -1.0f;
        for (Edge edge : njConn.getEdges()) {
            if ((edge.getSource() != parentInstance.getId() || edge.getTarget() != intoNodeId) && (edge.getSource() != intoNodeId || edge.getTarget() != parentInstance.getId())) continue;
            oldEdgeWeight = edge.getWeight();
            break;
        }
        Iterator<Edge> connIterator = njConn.getEdges().iterator();
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        while (connIterator.hasNext()) {
            Edge edge = connIterator.next();
            if (edge.getSource() == intoInstance.getId() && edge.getTarget() == parentInstance.getId()) {
                newEdges.add(new Edge(refRootInstance.getId(), parentInstance.getId(), oldEdgeWeight));
                connIterator.remove();
                continue;
            }
            if (edge.getSource() != parentInstance.getId() || edge.getTarget() != intoInstance.getId()) continue;
            newEdges.add(new Edge(parentInstance.getId(), refRootInstance.getId(), oldEdgeWeight));
            connIterator.remove();
        }
        njConn.getEdges().addAll(newEdges);
        Connectivity refNjConn = refTreeModel.getConnectivityByName("Neighbor-Joinning");
        njConn.getEdges().addAll(refNjConn.getEdges());
        this.removeSubTree(intoInstance);
        this.subTreeIds.clear();
        for (AbstractInstance ab : refTreeModel.instances) {
            SimpleTreeInstance refTreeInstance = (SimpleTreeInstance)ab;
            refTreeInstance.setX(intoInstance.getX());
            refTreeInstance.setY(intoInstance.getY());
            refTreeInstance.setModel(this);
            this.instances.add(refTreeInstance);
            this.subTreeIds.add(refTreeInstance.getId());
        }
        for (Scalar scalar : this.scalars) {
            for (Scalar refScalar : refTreeModel.scalars) {
                if (!scalar.equals(refScalar)) continue;
                if (scalar.getMax() < refScalar.getMax()) {
                    scalar.setMax(refScalar.getMax());
                }
                if (!(scalar.getMin() > refScalar.getMin())) continue;
                scalar.setMin(refScalar.getMin());
            }
        }
    }

    public SimpleTreeModel getSubtreeModel(int subtreeRootId) {
        if (subtreeRootId == this.root) {
            return this.clone();
        }
        SimpleTreeInstance subRoot = this.getInstanceById(subtreeRootId);
        SimpleTreeInstance parent = this.getInstanceById(subRoot.getParent());
        ArrayList<Integer> subtreeNodeIds = new ArrayList<Integer>();
        ArrayList<SimpleTreeInstance> subtreeNodes = new ArrayList<SimpleTreeInstance>();
        Stack<SimpleTreeInstance> nodeStack = new Stack<SimpleTreeInstance>();
        nodeStack.add(subRoot);
        while (!nodeStack.empty()) {
            SimpleTreeInstance currentNode = (SimpleTreeInstance)nodeStack.pop();
            subtreeNodeIds.add(currentNode.getId());
            subtreeNodes.add(this.getInstanceById(currentNode.getId()));
            for (int i = 0; i < currentNode.getNumChildren(); ++i) {
                nodeStack.push(this.getInstanceById(currentNode.getChildrenId(i)));
            }
        }
        Connectivity treeConn = this.getConnectivityByName("Neighbor-Joinning");
        ArrayList<Edge> treeEdges = treeConn.getEdges();
        ArrayList<Edge> subtreeEdges = new ArrayList<Edge>();
        for (Edge e : treeEdges) {
            if (!subtreeNodeIds.contains(e.getSource()) && !subtreeNodeIds.contains(e.getTarget())) continue;
            subtreeEdges.add(e);
        }
        SimpleTreeModel subtreeModel = this.clone();
        subtreeModel.connectivities.clear();
        SimpleTreeConnectivity subtreeConn = new SimpleTreeConnectivity("Neighbor-Joinning", subtreeEdges);
        subtreeModel.instances = subtreeNodes;
        subtreeModel.addConnectivity(subtreeConn);
        subtreeModel.root = subtreeRootId;
        subtreeModel.setScalars(this.scalars);
        return subtreeModel;
    }

    public SimpleTreeInstance getInstance(ArrayList<AbstractInstance> instances, int id) {
        for (AbstractInstance instance : instances) {
            if (instance.getId() != id) continue;
            return (SimpleTreeInstance)instance;
        }
        return null;
    }

    public SimpleTreeModel clone() {
        int i;
        SimpleTreeModel newModel = new SimpleTreeModel();
        newModel.instances = new ArrayList();
        for (int i2 = 0; i2 < this.instances.size(); ++i2) {
            ((SimpleTreeInstance)this.instances.get(i2)).createClone(newModel);
        }
        newModel.connectivities = new ArrayList();
        for (i = 0; i < this.connectivities.size(); ++i) {
            ArrayList<Edge> edges = new ArrayList<Edge>();
            for (int j = 0; j < ((Connectivity)this.connectivities.get(i)).getEdges().size(); ++j) {
                edges.add(new Edge(((Connectivity)this.connectivities.get(i)).getEdges().get(j).getSource(), ((Connectivity)this.connectivities.get(i)).getEdges().get(j).getTarget()));
            }
            SimpleTreeConnectivity conn = new SimpleTreeConnectivity(((Connectivity)this.connectivities.get(i)).getName(), edges);
            newModel.connectivities.add(conn);
        }
        newModel.scalars = new ArrayList();
        for (i = 0; i < this.scalars.size(); ++i) {
            Scalar scalar = new Scalar(((Scalar)this.scalars.get(i)).getName());
            scalar.store(((Scalar)this.scalars.get(i)).getMin());
            scalar.store(((Scalar)this.scalars.get(i)).getMax());
            newModel.scalars.add(scalar);
        }
        i = 0;
        if (this.selsconn != null) {
            i = this.connectivities.indexOf(this.selsconn);
            if (i != -1) {
                newModel.selsconn = (SimpleTreeConnectivity)newModel.connectivities.get(i);
            }
        } else {
            newModel.selsconn = null;
        }
        newModel.setInstanceSize(this.getInstanceSize());
        newModel.colortable = new ColorTable(this.colortable.getColorScaleType());
        newModel.alpha = this.alpha;
        newModel.root = this.root;
        newModel.type = this.type;
        newModel.selscalar = this.selscalar;
        newModel.setInstanceSize(this.getInstanceSize());
        return newModel;
    }

    public void draw(Graphics2D g2, boolean highquality) {
        SimpleTreeInstance gi;
        if (this.selsconn != null) {
            ((SimpleTreeConnectivity)this.selsconn).draw(this, g2, highquality);
        }
        for (AbstractInstance instance : this.instances) {
            gi = (SimpleTreeInstance)instance;
            if (gi.isValid()) continue;
            gi.draw(g2, highquality);
        }
        for (AbstractInstance instance : this.instances) {
            gi = (SimpleTreeInstance)instance;
            if (!gi.isValid() || gi.isSelected()) continue;
            gi.draw(g2, highquality);
        }
        for (AbstractInstance instance : this.instances) {
            gi = (SimpleTreeInstance)instance;
            if (!gi.isValid() || !gi.isSelected()) continue;
            gi.draw(g2, highquality);
        }
        SimpleTreeInstance gi2 = this.getInstanceById(this.highLightInstanceId);
        if (gi2 != null) {
            gi2.drawHighlight(g2, highquality);
        }
    }

    @Override
    public void draw(BufferedImage image, boolean highquality) {
        if (image != null) {
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            this.draw(g2, highquality);
        }
    }

    public Rectangle getImagePosition() {
        float maxX = Float.MIN_VALUE;
        float minX = Float.MAX_VALUE;
        float maxY = Float.MIN_VALUE;
        float minY = Float.MAX_VALUE;
        for (AbstractInstance instance : this.instances) {
            SimpleTreeInstance treeInstance = (SimpleTreeInstance)instance;
            if (maxX < treeInstance.getX()) {
                maxX = treeInstance.getX();
            }
            if (minX > treeInstance.getX()) {
                minX = treeInstance.getX();
            }
            if (maxY < treeInstance.getY()) {
                maxY = treeInstance.getY();
            }
            if (!(minY > treeInstance.getY())) continue;
            minY = treeInstance.getY();
        }
        return new Rectangle((int)minX, (int)minY, (int)maxX - (int)minX, (int)maxY - (int)minY);
    }

    public MultiscaleParams getMultiscaleParams() {
        return this.multiscaleParams;
    }

    public void setMultiscaleParams(MultiscaleParams multiscaleParams) {
        this.multiscaleParams = multiscaleParams;
    }

    @Override
    public SimpleTreeConnectivity getSelectedConnectivity() {
        return (SimpleTreeConnectivity)this.selsconn;
    }

    public void setSelectedInstance(SimpleTreeInstance selinst) {
        if (selinst != null) {
            this.cleanSelectedInstances();
            if (selinst.getModel() == this) {
                selinst.setSelected(true);
                this.selinstances.add(selinst);
                for (int i = 0; i < selinst.getNumChildren(); ++i) {
                    SimpleTreeInstance ch = this.getInstanceById(selinst.getChildrenId(i));
                    if (ch == null) continue;
                    this.setSelectedInstance(ch);
                }
            }
            this.setChanged();
        }
    }

    public void setInstances(ArrayList<AbstractInstance> instances) {
        this.instances = instances;
    }

    public ArrayList<AbstractInstance> getValidSelectedInstances() {
        ArrayList<AbstractInstance> selinsts = this.getSelectedInstances();
        ArrayList<AbstractInstance> valids = new ArrayList<AbstractInstance>();
        if (selinsts != null) {
            for (int i = 0; i < selinsts.size(); ++i) {
                if (!((SimpleTreeInstance)selinsts.get(i)).isValid() || valids.contains(selinsts.get(i))) continue;
                valids.add(selinsts.get(i));
            }
        }
        return valids;
    }

    public ArrayList<AbstractInstance> getValidInstances() {
        ArrayList selinsts = this.instances;
        ArrayList<AbstractInstance> valids = new ArrayList<AbstractInstance>();
        if (selinsts != null) {
            for (int i = 0; i < selinsts.size(); ++i) {
                if (!((SimpleTreeInstance)selinsts.get(i)).isValid()) continue;
                valids.add((AbstractInstance)selinsts.get(i));
            }
        }
        return valids;
    }

    public Scalar getScalarByName(String name) {
        for (Scalar s : this.scalars) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public void changeRoot(int newRootId) {
        this.root = newRootId;
        SimpleTreeInstance newRootNode = this.getInstanceById(newRootId);
        newRootNode.setParent(-1);
        HashSet<Integer> processedNodes = new HashSet<Integer>();
        Stack<Integer> toProcessStack = new Stack<Integer>();
        Connectivity njConn = this.getConnectivityByName("Neighbor-Joinning");
        ArrayList<Edge> edges = njConn.getEdges();
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        ArrayList<Edge> edgesToAdd = new ArrayList<Edge>();
        toProcessStack.add(newRootId);
        while (!toProcessStack.empty()) {
            SimpleTreeInstance currentNode = this.getInstanceById((Integer)toProcessStack.pop());
            ArrayList<Integer> connectedNodes = new ArrayList<Integer>();
            ArrayList<Float> connectedWeights = new ArrayList<Float>();
            for (Edge edge : edges) {
                if (edge.getSource() == currentNode.getId()) {
                    if (processedNodes.contains(edge.getTarget())) continue;
                    connectedNodes.add(edge.getTarget());
                    connectedWeights.add(Float.valueOf(edge.getWeight()));
                    toProcessStack.add(edge.getTarget());
                    continue;
                }
                if (edge.getTarget() != currentNode.getId() || processedNodes.contains(edge.getSource())) continue;
                connectedNodes.add(edge.getSource());
                connectedWeights.add(Float.valueOf(edge.getWeight()));
                toProcessStack.add(edge.getSource());
                edgesToRemove.add(edge);
                edgesToAdd.add(new Edge(currentNode.getId(), edge.getSource(), edge.getWeight()));
            }
            if (!connectedNodes.isEmpty()) {
                int[] childrenIds = new int[connectedNodes.size()];
                float[] childrenDistances = new float[connectedNodes.size()];
                for (int i = 0; i < connectedNodes.size(); ++i) {
                    SimpleTreeInstance child = this.getInstanceById((Integer)connectedNodes.get(i));
                    child.setParent(currentNode.getId());
                    childrenIds[i] = (Integer)connectedNodes.get(i);
                    childrenDistances[i] = ((Float)connectedWeights.get(i)).floatValue();
                }
                currentNode.setChildren(childrenIds);
                currentNode.childrenDist = childrenDistances;
            }
            processedNodes.add(currentNode.getId());
        }
        toProcessStack.clear();
        for (AbstractInstance ai : this.instances) {
            if (((SimpleTreeInstance)ai).level == 0) {
                toProcessStack.add(ai.getId());
            }
            ((SimpleTreeInstance)ai).level = 0;
        }
        while (!toProcessStack.isEmpty()) {
            LinkedList<SimpleTreeInstance> currentNodeHierarchy = new LinkedList<SimpleTreeInstance>();
            SimpleTreeInstance currentInstance = this.getInstanceById((Integer)toProcessStack.pop());
            SimpleTreeInstance parent = this.getInstanceById(currentInstance.getParent());
            while (parent != null) {
                currentNodeHierarchy.add(parent);
                parent = this.getInstanceById(parent.getParent());
            }
            int currentLevel = currentInstance.level + 1;
            while (currentNodeHierarchy.size() > 0) {
                parent = (SimpleTreeInstance)currentNodeHierarchy.pop();
                if (parent.level >= currentLevel) continue;
                parent.level = currentLevel++;
            }
        }
        njConn.getEdges().removeAll(edgesToRemove);
        njConn.getEdges().addAll(edgesToAdd);
    }

    public void addScalar(Scalar scalar) {
        if (!this.scalars.contains(scalar)) {
            this.scalars.add(scalar);
        }
    }

    public void setScalars(ArrayList<Scalar> scalars) {
        this.scalars = scalars;
    }

    public void setColortable(ColorTable colorTable) {
        this.colortable = colorTable;
    }

    public void setConnectivities(ArrayList<Connectivity> conns) {
        this.connectivities = conns;
    }

    public SimpleTreeInstance getInstanceById(int id) {
        for (AbstractInstance instance : this.instances) {
            if (instance.getId() != id) continue;
            return (SimpleTreeInstance)instance;
        }
        return null;
    }

    @Override
    public void setSelectedScalar(Scalar scalar) {
        if (this.scalars.contains(scalar)) {
            this.selscalar = scalar;
            for (int i = 0; i < this.getValidInstances().size(); ++i) {
                SimpleTreeInstance pi = (SimpleTreeInstance)this.getValidInstances().get(i);
                if (scalar.getMin() >= 0.0f && scalar.getMax() <= 1.0f) {
                    pi.setColor(this.colortable.getColor(pi.getScalarValue(scalar)));
                    continue;
                }
                try {
                    float normalizedScalarValue = pi.getNormalizedScalarValue(scalar);
                    Color instanceColor = this.colortable.getColor(normalizedScalarValue);
                    pi.setColor(instanceColor);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("Error setting color for instance " + pi.getId());
                    throw e;
                }
            }
        } else {
            this.selscalar = null;
            for (AbstractInstance instance : this.instances) {
                ProjectionInstance pi = (ProjectionInstance)instance;
                pi.setColor(Color.BLACK);
            }
        }
        this.setChanged();
    }

    @Override
    public ArrayList<ProjectionInstance> getInstancesByPosition(Polygon polygon) {
        ArrayList<ProjectionInstance> selected = new ArrayList<ProjectionInstance>();
        for (AbstractInstance instance : this.instances) {
            ProjectionInstance pi = (ProjectionInstance)instance;
            if (!polygon.contains(pi.getX(), pi.getY())) continue;
            selected.add(pi);
        }
        return selected;
    }

    @Override
    public ArrayList<ProjectionInstance> getInstancesByPosition(Rectangle rect) {
        ArrayList<ProjectionInstance> selected = new ArrayList<ProjectionInstance>();
        for (AbstractInstance instance : this.instances) {
            ProjectionInstance pi = (ProjectionInstance)instance;
            if (!pi.isInside(rect)) continue;
            selected.add(pi);
        }
        return selected;
    }

    @Override
    public SimpleTreeInstance getInstanceByPosition(Point point) {
        for (AbstractInstance instance : this.instances) {
            SimpleTreeInstance pi = (SimpleTreeInstance)instance;
            if (!pi.isInside(point.x, point.y)) continue;
            return pi;
        }
        return null;
    }

    public Edge getEdgeByPosition(Point p) {
        SimpleTreeConnectivity conn = this.getSelectedConnectivity();
        for (Edge edge : conn.getEdges()) {
            Line2D.Float line;
            SimpleTreeInstance source = this.getInstanceById(edge.getSource());
            SimpleTreeInstance target = this.getInstanceById(edge.getTarget());
            if (source == null || target == null || !(line = new Line2D.Float(source.getX(), source.getY(), target.getX(), target.getY())).intersects(p.x, p.y, 1.0, 1.0)) continue;
            return edge;
        }
        return null;
    }

    public void normalizeVertex(Rectangle visualizationArea) {
        float maxX = Float.NEGATIVE_INFINITY;
        float minX = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (maxX < pi.getX()) {
                maxX = pi.getX();
            }
            if (minX > pi.getX()) {
                minX = pi.getX();
            }
            if (maxY < pi.getY()) {
                maxY = pi.getY();
            }
            if (!(minY > pi.getY())) continue;
            minY = pi.getY();
        }
        float beginX = visualizationArea.x;
        float endX = visualizationArea.x + visualizationArea.width;
        float beginY = visualizationArea.y;
        float endY = visualizationArea.y + visualizationArea.height;
        for (AbstractInstance instance : this.instances) {
            ProjectionInstance pi = (ProjectionInstance)instance;
            if (maxX != minX) {
                pi.setX((pi.getX() - minX) / (maxX - minX) * (endX - beginX) + beginX);
            } else {
                pi.setX(beginX);
            }
            if (maxY != minY) {
                pi.setY((pi.getY() - minY) / (maxY - minY) * (endY - beginY) + beginY);
                continue;
            }
            pi.setY(beginY);
        }
    }

    public void removeInstance(SimpleTreeInstance node) {
        int i;
        SimpleTreeInstance parent = this.getInstanceById(node.getParent());
        if (parent == null) {
            if (node.hasChildren()) {
                for (i = 0; i < node.getNumChildren(); ++i) {
                    if (node.getChildrenId(i) == -1) continue;
                    SimpleTreeInstance child = this.getInstanceById(node.getChildrenId(i));
                    child.setParent(-1);
                    this.setRoot(child.getId());
                }
            }
        } else {
            for (i = 0; i < parent.getNumChildren(); ++i) {
                if (parent.getChildrenId(i) != node.getId()) continue;
                parent.setChildrenId(i, -1);
                break;
            }
        }
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        for (Edge e : this.getConnectivityByName("Neighbor-Joinning").getEdges()) {
            if (e.getSource() != node.getId() && e.getTarget() != node.getId()) continue;
            edgesToRemove.add(e);
        }
        this.getConnectivityByName("Neighbor-Joinning").getEdges().removeAll(edgesToRemove);
        this.instances.remove(node);
    }

    public void removeSubTree(SimpleTreeInstance refNode) {
        SimpleTreeInstance parentNode;
        int childId;
        int i;
        if (refNode.hasChildren()) {
            int childCount = refNode.getNumChildren();
            for (i = 0; i < childCount; ++i) {
                childId = refNode.getChildrenId(i);
                SimpleTreeInstance childNode = this.getInstanceById(childId);
                this.removeSubTree(childNode);
            }
        }
        if ((parentNode = this.getInstanceById(refNode.getParent())) != null) {
            for (i = 0; i < parentNode.getNumChildren(); ++i) {
                childId = parentNode.getChildrenId(i);
                if (childId != refNode.getId()) continue;
                parentNode.setChildrenId(i, -1);
                break;
            }
        }
        Connectivity conn = this.getConnectivityByName("Neighbor-Joinning");
        Iterator<Edge> connIterator = conn.getEdges().iterator();
        while (connIterator.hasNext()) {
            Edge edge = connIterator.next();
            if (edge.getSource() != refNode.getId() && edge.getTarget() != refNode.getId()) continue;
            connIterator.remove();
        }
        this.instances.remove(refNode);
    }

    public int getCentralNode() {
        ArrayList<SimpleTreeInstance> instancesToDelete;
        SimpleTreeModel stCloneModel = this.clone();
        for (int numInstances = stCloneModel.getInstances().size(); numInstances > 1; numInstances -= instancesToDelete.size()) {
            instancesToDelete = new ArrayList<SimpleTreeInstance>();
            HashMap<Integer, Integer> nodeConnectionsMap = new HashMap<Integer, Integer>();
            for (Edge edge : stCloneModel.getConnectivityByName("Neighbor-Joinning").getEdges()) {
                if (!nodeConnectionsMap.containsKey(edge.getSource())) {
                    nodeConnectionsMap.put(edge.getSource(), 1);
                } else {
                    nodeConnectionsMap.put(edge.getSource(), (Integer)nodeConnectionsMap.get(edge.getSource()) + 1);
                }
                if (!nodeConnectionsMap.containsKey(edge.getTarget())) {
                    nodeConnectionsMap.put(edge.getTarget(), 1);
                    continue;
                }
                nodeConnectionsMap.put(edge.getTarget(), (Integer)nodeConnectionsMap.get(edge.getTarget()) + 1);
            }
            for (Map.Entry entry : nodeConnectionsMap.entrySet()) {
                if ((Integer)entry.getValue() != 1) continue;
                instancesToDelete.add(stCloneModel.getInstanceById((Integer)entry.getKey()));
            }
            for (AbstractInstance abstractInstance : instancesToDelete) {
                if (stCloneModel.getInstances().size() <= 1) continue;
                stCloneModel.removeInstance((SimpleTreeInstance)abstractInstance);
            }
        }
        int centralNodeId = stCloneModel.getInstances().get(0).getId();
        return centralNodeId;
    }

    public int getCentralNodeFabinho() {
        SimpleTreeModel stCloneModel = this.clone();
        ArrayList<AbstractInstance> instancesToDelete = new ArrayList<AbstractInstance>();
        for (Object ai : stCloneModel.instances) {
            if (((SimpleTreeInstance)ai).getNumChildren() != 0) continue;
            instancesToDelete.add((AbstractInstance)ai);
        }
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        for (Edge e : stCloneModel.getConnectivityByName("Neighbor-Joinning").getEdges()) {
            for (AbstractInstance abstractInstance : instancesToDelete) {
                if (abstractInstance.getId() != e.getSource() && abstractInstance.getId() != e.getTarget()) continue;
                edgesToRemove.add(e);
            }
        }
        stCloneModel.instances.removeAll(instancesToDelete);
        stCloneModel.getConnectivityByName("Neighbor-Joinning").getEdges().removeAll(edgesToRemove);
        for (int numInstances = stCloneModel.getInstances().size(); numInstances > 1; numInstances -= instancesToDelete.size()) {
            HashMap<Integer, Integer> nodeConnectionsMap = new HashMap<Integer, Integer>();
            for (Edge edge : stCloneModel.getConnectivityByName("Neighbor-Joinning").getEdges()) {
                if (!nodeConnectionsMap.containsKey(edge.getSource())) {
                    nodeConnectionsMap.put(edge.getSource(), 1);
                } else {
                    nodeConnectionsMap.put(edge.getSource(), (Integer)nodeConnectionsMap.get(edge.getSource()) + 1);
                }
                if (!nodeConnectionsMap.containsKey(edge.getTarget())) {
                    nodeConnectionsMap.put(edge.getTarget(), 1);
                    continue;
                }
                nodeConnectionsMap.put(edge.getTarget(), (Integer)nodeConnectionsMap.get(edge.getTarget()) + 1);
            }
            for (Map.Entry entry : nodeConnectionsMap.entrySet()) {
                if ((Integer)entry.getValue() != 1) continue;
                instancesToDelete.add(stCloneModel.getInstanceById((Integer)entry.getKey()));
            }
            for (AbstractInstance abstractInstance : instancesToDelete) {
                if (stCloneModel.getInstances().size() <= 1) continue;
                stCloneModel.removeInstance((SimpleTreeInstance)abstractInstance);
            }
        }
        int centralNodeId = stCloneModel.getInstances().get(0).getId();
        return centralNodeId;
    }

    public int getRoot() {
        return this.root;
    }

    public void setRoot(int root) {
        this.root = root;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNoAlpha() {
        return this.noAlpha;
    }

    public void setNoAlpha(boolean noAlpha) {
        this.noAlpha = noAlpha;
    }

    public void removeScalar(Scalar scalar) {
        int index = this.scalars.indexOf(scalar);
        if (index != -1) {
            for (AbstractInstance pi : this.instances) {
                ((SimpleTreeInstance)pi).removeScalar(index);
            }
        }
        this.scalars.remove(scalar);
    }

    public String toString() {
        if (this.source == null || this.source.isEmpty()) {
            return "Simple Tree Model";
        }
        return this.source;
    }

    @Override
    public void removeSelectedInstances() {
        ArrayList<Connectivity> conns = this.getConnectivities();
        if (conns != null) {
            for (int i = 0; i < conns.size(); ++i) {
                Connectivity conn = conns.get(i);
                ArrayList<Edge> edges = conn.getEdges();
                if (edges == null) continue;
                for (int j = 0; j < edges.size(); ++j) {
                    if (!this.containsInstances(edges.get(j))) continue;
                    edges.remove(j);
                    --j;
                }
            }
        }
        super.removeSelectedInstances();
    }

    private boolean containsInstances(Edge e) {
        for (int i = 0; i < this.selinstances.size(); ++i) {
            if (e.getSource() != ((AbstractInstance)this.selinstances.get(i)).getId() && e.getTarget() != ((AbstractInstance)this.selinstances.get(i)).getId()) continue;
            return true;
        }
        return false;
    }

    public boolean isDrawAsImage() {
        return this.drawAsImage;
    }

    public void setDrawAsImage(boolean i) {
        this.drawAsImage = i;
        this.setChanged();
    }

    public boolean isDrawImageFrame() {
        return this.drawImageFrame;
    }

    public void setDrawImageFrame(boolean i) {
        this.drawImageFrame = i;
        this.setChanged();
    }

    public boolean checkImages(ImageCollection ic) {
        return true;
    }

    public HashMap<Integer, String> getLabels() {
        return this.labels;
    }

    public void setLabels(HashMap<Integer, String> labels) {
        this.labels = labels;
    }

    public HashMap<Integer, Image> getImages() {
        return this.images;
    }

    public void setImages(HashMap<Integer, Image> imgs) {
        this.images = imgs;
    }

    public void setImageCollectionPath(String filename) {
        this.imageCollectionPath = filename;
    }

    public String getImageCollectionPath() {
        return this.imageCollectionPath;
    }

    public void setImagesSize(int s) {
        this.imagesSize = s;
        this.setChanged();
    }

    public int getImagesSize() {
        return this.imagesSize;
    }

    public void print() {
        int i;
        System.out.println("Root: " + this.root);
        for (i = 0; i < this.instances.size(); ++i) {
            SimpleTreeInstance sti = (SimpleTreeInstance)this.instances.get(i);
            System.out.print(sti.getId());
            if (sti.hasChildren()) {
                System.out.print(" : ");
                for (int j = 0; j < sti.getNumChildren(); ++j) {
                    System.out.print(sti.getChildrenId(j) + " ");
                }
            }
            System.out.println("");
        }
        System.out.println("---");
        for (i = 0; i < this.getSelectedConnectivity().getEdges().size(); ++i) {
            System.out.println("EDGE SOURCE: " + this.getSelectedConnectivity().getEdges().get(i).getSource() + "+TARGET: " + this.getSelectedConnectivity().getEdges().get(i).getTarget());
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String s) {
        this.source = s;
    }

    public void setTablePScalar(TablePScalar table) {
        this.tablePScalar = table;
    }

    public TablePScalar getTablePScalar() {
        return this.tablePScalar;
    }

    public void updateTablePScalar(TablePScalar tablemodel) {
        if (this.labels != null && !this.labels.isEmpty()) {
            for (int j = 0; j < this.getValidInstances().size(); ++j) {
                String label;
                SimpleTreeInstance tins = (SimpleTreeInstance)this.getValidInstances().get(j);
                int indexTableModel = tablemodel == null ? -1 : ((label = this.labels.get(tins.getId())) != null && !label.isEmpty() ? tablemodel.getNumRowGiveName(label) : -1);
                if (indexTableModel < 0) continue;
                String filename = (String)tablemodel.getValueAt(indexTableModel, 1);
                float scalarValue = Float.valueOf(tablemodel.getValueAt(indexTableModel, 3).toString().trim()).floatValue();
                label = this.labels.get(tins.getId());
                int indexTablePScalar = label != null && !label.isEmpty() ? this.tablePScalar.getNumRowGiveName(label) : -1;
                if (indexTablePScalar < 0) continue;
                this.tablePScalar.setValueAt(filename, indexTablePScalar, 1);
                this.tablePScalar.setValueAt(Float.valueOf(scalarValue), indexTablePScalar, 3);
            }
        } else {
            JOptionPane.showMessageDialog(null, "No source data set found! Connect it to correspondent viewer component on the pipeline", "Error", 0, null);
        }
    }

    public void updateTablePScalar(Scalar s) {
        if (this.labels != null && !this.labels.isEmpty()) {
            ArrayList<PseudoClass> pClasses = new ArrayList<PseudoClass>();
            for (int j = 0; j < this.getValidInstances().size(); ++j) {
                float scalarValue;
                SimpleTreeInstance v = (SimpleTreeInstance)this.getValidInstances().get(j);
                String label = this.labels.get(v.getId());
                int indexTablePScalar = this.tablePScalar == null ? -1 : this.tablePScalar.getNumRowGiveName(label);
                if (indexTablePScalar < 0) {
                    scalarValue = v.getScalarValue(s);
                    label = "class" + (int)scalarValue;
                } else {
                    label = (String)this.tablePScalar.getValueAt(indexTablePScalar, 1);
                    scalarValue = Float.valueOf(this.tablePScalar.getValueAt(indexTablePScalar, 3).toString().trim()).floatValue();
                }
                PseudoClass pseudoClass = new PseudoClass(v.getId(), this.labels.get(v.getId()), label, true, Float.valueOf(scalarValue));
                pClasses.add(pseudoClass);
            }
            try {
                this.tablePScalar = new TablePScalar(pClasses, null);
            }
            catch (Exception ex) {
                System.err.println("Caught: " + ex);
            }
        } else {
            JOptionPane.showMessageDialog(null, "No source data set found! Connect it to correspondent viewer component on the pipeline", "Error", 0, null);
        }
    }

    public void setClassMap(HashMap<Integer, Float> classMap) {
        this.classMap = classMap;
    }

    public HashMap<Integer, Float> getClassMap() {
        return this.classMap;
    }

    public AbstractMatrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public int getMultiScaleLevel() {
        return this.multiScaleLevel;
    }

    public void setMultiScaleLevel(int multiScaleLevel) {
        this.multiScaleLevel = multiScaleLevel;
    }

    public int getHighLightInstanceId() {
        return this.highLightInstanceId;
    }

    public void setHighLightInstanceId(int highLightInstanceId) {
        this.highLightInstanceId = highLightInstanceId;
    }

    public boolean isIsShowInstancesVoronoi() {
        return this.showInstancesVoronoi;
    }

    public void setShowInstancesVoronoi(boolean showInstancesVoronoi) {
        this.showInstancesVoronoi = showInstancesVoronoi;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public void setCorpus(Corpus c) {
        this.corpus = c;
    }

    public ArrayList<AbstractInstance> getInstancesCluster(SimpleTree tree) {
        ArrayList<AbstractInstance> listClusters = new ArrayList<AbstractInstance>();
        Scalar cdata = this.addScalar("cdata");
        Scalar dots = this.addScalar("...");
        if (tree != null) {
            for (int i = 0; i < tree.getSize(); ++i) {
                ContentSimpleTree node = tree.getNode(i);
                if (node == null) continue;
                SimpleTreeInstance ti = node instanceof ClusterContentSimpleTree ? new ClusterSimpleTreeInstance(node.getId(), 0.0f, 0.0f, node.isValid(), ((ClusterContentSimpleTree)node).getTree()) : new SimpleTreeInstance(node.getId(), 0.0f, 0.0f, node.isValid());
                for (int j = 0; j < node.getNumChildren(); ++j) {
                    ti.setChildrenId(j, node.getChildrenId(j));
                }
                ti.setParent(node.getParent());
                ti.setRecursiveChildCount(node.getRecursiveChildCount());
                listClusters.add(ti);
            }
        }
        return listClusters;
    }

    public SupertreeFile getSupertreeFile() {
        return this.stFile;
    }

    public void setSupertreeFile(SupertreeFile stFile) {
        this.stFile = stFile;
    }

    public List<Integer> getSubTreeIds() {
        return this.subTreeIds;
    }

    public void setSubTreeIds(List<Integer> subTreeIds) {
        this.subTreeIds = subTreeIds;
    }
}

