/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import simpletree.basics.SimpleTree;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.file.SupertreeFile;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.SimpleTreeConnectivity;
import simpletree.model.SimpleTreeModel;
import simpletree.model.SimpleTreeModelParamView;
import simpletree.model.content.LabelContent;
import simpletree.util.SimpleTreeUtil;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Basics", name="Simple Tree Model", description="Create a simple tree model to be visualized.")
public class SimpleTreeModelComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String collection;
    private transient SimpleTreeModelParamView paramview;
    private transient SimpleTreeModel model;
    private transient AbstractMatrix placement;
    private transient ArrayList<SimpleTreeConnectivity> conns;
    private transient SimpleTree tree;
    private transient SupertreeFile stFile;
    private String source;

    public void execute() throws IOException {
        if (this.placement != null || this.tree != null) {
            this.model = new SimpleTreeModel();
            if (this.tree != null) {
                this.model = new SimpleTreeModel(this.tree);
                LabelContent labelContent = this.tree.getLabelContent();
                this.model.addContent(labelContent);
                if (labelContent != null) {
                    this.model.setLabels((HashMap)labelContent.getMap());
                } else if (this.tree.getLabelMap() != null && !this.tree.getLabelMap().isEmpty()) {
                    this.model.setLabels(this.tree.getLabelMap());
                }
            } else {
                this.model = new SimpleTreeModel(this.placement, this.conns, this.collection);
                this.model.changeRoot(this.model.getCentralNode());
            }
            this.model.setSource(this.source);
        } else if (this.stFile != null) {
            this.stFile.Cluster.loadHeader();
            int matrixSize = this.stFile.Cluster.Metadata.inputMatrixSize;
            TreeCluster rootCluster = this.stFile.Cluster.load(matrixSize);
            String rootNewick = rootCluster.getNewick();
            SimpleTree stree = new SimpleTree(rootNewick);
            SimpleTreeUtil.convertToSuperTree(stree, rootCluster, 1, 2, this.stFile);
            stree.generateEdges();
            this.model = new SimpleTreeModel(stree);
            this.model.changeRoot(this.model.getCentralNode());
            this.model.setSupertreeFile(this.stFile);
        } else {
            throw new IOException("A 2D position and a tree structure should be provided.");
        }
    }

    public void input(@Param(name="Tree Data") SimpleTree tree) {
        this.tree = tree;
    }

    public void input(@Param(name="Supertree File") SupertreeFile stFile) {
        this.stFile = stFile;
    }

    public SimpleTreeModel output() {
        return this.model;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new SimpleTreeModelParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.placement = null;
        this.model = null;
        this.conns = null;
        this.tree = null;
    }

    public void setCollection(String c) {
        this.collection = c;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String s) {
        this.source = s;
    }
}

