/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.io.IOException;
import simpletree.model.ProjectionModel;
import simpletree.model.XMLModelReader;
import simpletree.model.XMLModelReaderParamView;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Input", name="Projection model XML reader", description="Read a projection model from an XML file.")
public class XMLModelReaderComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private transient ProjectionModel model;
    private transient XMLModelReaderParamView paramview;

    public void execute() throws IOException {
        if (this.filename.trim().length() <= 0) {
            throw new IOException("A projection model file name must be provided to write.");
        }
        XMLModelReader xmr = new XMLModelReader();
        this.model = new ProjectionModel();
        xmr.read(this.model, this.filename);
    }

    public ProjectionModel output() {
        return this.model;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new XMLModelReaderParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

