/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;

public class XMLModelWriter {
    public void write(ProjectionModel model, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "ISO-8859-1"));
            out.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\r\n");
            out.write("<!--   instances   -->\r\n");
            ArrayList<AbstractInstance> instances = model.getInstances();
            for (AbstractInstance ai : instances) {
                ProjectionInstance pi = (ProjectionInstance)ai;
                out.write("<instance id=\"");
                out.write(Integer.toString(pi.getId()));
                out.write("\">\r\n");
                out.write("<x-coordinate value=\"");
                out.write(Float.toString(pi.getX()));
                out.write("\"/>\r\n");
                out.write("<y-coordinate value=\"");
                out.write(Float.toString(pi.getY()));
                out.write("\"/>\r\n");
                out.write("<scalars>\r\n");
                for (Scalar s : model.getScalars()) {
                    out.write("<scalar name=\"");
                    out.write(s.getName().replaceAll("\"", "'"));
                    out.write("\" value=\"");
                    out.write(Float.toString(pi.getScalarValue(s)));
                    out.write("\"/>\r\n");
                }
                out.write("</scalars>\r\n");
                out.write("</instance>\r\n");
            }
            out.write("</projection>\r\n");
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + "\"");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(XMLModelWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static String convert(String value) {
        if (value == null) {
            return "";
        }
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("\"", "&quot;");
        value = value.replaceAll("'", "&#39;");
        return value;
    }

    public static String deConvert(String value) {
        if (value == null) {
            return "";
        }
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&#39;", "'");
        return value;
    }

    public static String encodeToValidChars(String pData) {
        StringBuffer encodedData = new StringBuffer();
        for (int i = 0; i < pData.length(); ++i) {
            char ch = pData.charAt(i);
            char chVal = ch;
            if (chVal >= ' ' && chVal <= '\u00ff') {
                encodedData.append(chVal);
                continue;
            }
            encodedData.append(" ");
        }
        return encodedData.toString();
    }
}

