/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.newick;

import java.io.IOException;
import simpletree.basics.SimpleTree;
import simpletree.model.newick.NewickTreeReaderParamView;
import simpletree.technique.packagenj.PackageNJ;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Input", name="Newick Tree reader", description="Read a tree from an Newick file.")
public class NewickTreeReaderComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private boolean promotion = true;
    private transient SimpleTree tree;
    private transient NewickTreeReaderParamView paramview;

    public void execute() throws IOException {
        if (this.filename.trim().length() > 0) {
            this.tree = new SimpleTree(this.filename.trim());
            if (this.promotion) {
                PackageNJ.promoteLeafs(this.tree);
            }
        } else {
            throw new IOException("A newick tree file name must be provided to write.");
        }
        this.tree.generateEdges();
    }

    public SimpleTree output() {
        return this.tree;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new NewickTreeReaderParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.tree = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setPromotion(boolean p) {
        this.promotion = p;
    }

    public boolean isPromotion() {
        return this.promotion;
    }
}

