/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.xml;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.model.AbstractInstance;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.xml.XMLGraphModelWriter;

public class XMLSimpleTreeModelWriter
extends XMLGraphModelWriter {
    public void write(SimpleTreeModel model, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "ISO-8859-1"));
            out.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\r\n");
            out.write("<tree>\r\n");
            out.write("<root value=\"");
            out.write(Integer.toString(model.getRoot()));
            out.write("\"/>\r\n");
            out.write("<type value=\"");
            out.write(model.getType());
            out.write("\"/>\r\n");
            out.write("<noalpha value=\"");
            out.write(Boolean.toString(model.isNoAlpha()));
            out.write("\"/>\r\n");
            out.write("<alpha value=\"");
            out.write(Float.toString(model.getAlpha()));
            out.write("\"/>\r\n");
            out.write("<!--   instances   -->\r\n");
            ArrayList<AbstractInstance> instances = model.getInstances();
            for (AbstractInstance ai : instances) {
                SimpleTreeInstance pi = (SimpleTreeInstance)ai;
                out.write("<instance id=\"");
                out.write(Integer.toString(pi.getId()));
                out.write("\">\r\n");
                out.write("<valid value=\"");
                out.write(Boolean.toString(pi.isValid()));
                out.write("\"/>\r\n");
                out.write("<x-coordinate value=\"");
                out.write(Float.toString(pi.getX()));
                out.write("\"/>\r\n");
                out.write("<y-coordinate value=\"");
                out.write(Float.toString(pi.getY()));
                out.write("\"/>\r\n");
                out.write("<scalars>\r\n");
                for (Scalar s : model.getScalars()) {
                    out.write("<scalar name=\"");
                    out.write(s.getName().replaceAll("\"", "'"));
                    out.write("\" value=\"");
                    out.write(Float.toString(pi.getScalarValue(s)));
                    out.write("\"/>\r\n");
                }
                out.write("</scalars>\r\n");
                out.write("</instance>\r\n");
            }
            out.write("<selconn value=\"");
            out.write(model.getSelectedConnectivity().getName());
            out.write("\"/>\r\n");
            out.write("<!--   edges   -->\r\n");
            ArrayList<Connectivity> cons = model.getConnectivities();
            for (int i = 0; i < cons.size(); ++i) {
                out.write("<edges name=\"");
                out.write(cons.get(i).getName());
                out.write("\">\r\n");
                for (Edge e : cons.get(i).getEdges()) {
                    out.write("<edge source=\"");
                    out.write(Integer.toString(e.getSource()));
                    out.write("\" target=\"");
                    out.write(Long.toString(e.getTarget()));
                    out.write("\" length=\"");
                    out.write(Float.toString(e.getWeight()));
                    out.write("\"/>\r\n");
                }
                out.write("</edges>\r\n");
            }
            out.write("</tree>\r\n");
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + "\"");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(XMLSimpleTreeModelWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

