/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.xml;

import java.io.IOException;
import simpletree.model.SimpleTreeModel;
import simpletree.model.xml.XMLSimpleTreeModelWriter;
import simpletree.model.xml.XMLSimpleTreeModelWriterParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Output", name="Simple Tree Model XML writer", description="Write a simple tree model to a XML file.")
public class XMLSimpleTreeModelWriterComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private transient XMLSimpleTreeModelWriterParamView paramview;
    private transient SimpleTreeModel model;

    public void execute() throws IOException {
        if (this.filename.trim().length() > 0) {
            if (this.model == null) {
                throw new IOException("A tree model must be provided to write.");
            }
        } else {
            throw new IOException("A tree model file name must be provided to write.");
        }
        XMLSimpleTreeModelWriter xmw = new XMLSimpleTreeModelWriter();
        xmw.write(this.model, this.filename);
    }

    public void input(@Param(name="model") SimpleTreeModel model) {
        this.model = model;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new XMLSimpleTreeModelWriterParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

