/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.stress;

import simpletree.projection.stress.KruskalStress;
import simpletree.projection.stress.NormalizedKruskalStress;
import simpletree.projection.stress.PartialNormalizedKruskalStress;
import simpletree.projection.stress.QuadraticStress;
import simpletree.projection.stress.SammonStress;
import simpletree.projection.stress.Stress;

public class StressFactory {
    public static Stress getInstance(StressType type) {
        if (type.equals((Object)StressType.KRUSKAL)) {
            return new KruskalStress();
        }
        if (type.equals((Object)StressType.NORMALIZED_KRUSKAL)) {
            return new NormalizedKruskalStress();
        }
        if (type.equals((Object)StressType.PARTIAL_NORMALIZED_KRUSKAL)) {
            return new PartialNormalizedKruskalStress();
        }
        if (type.equals((Object)StressType.SAMMON)) {
            return new SammonStress();
        }
        if (type.equals((Object)StressType.QUADRATIC_STRESS)) {
            return new QuadraticStress();
        }
        return null;
    }

    public static enum StressType {
        KRUSKAL("Kruskal's stress"),
        NORMALIZED_KRUSKAL("Normalized Kruskal's stress"),
        PARTIAL_NORMALIZED_KRUSKAL("Sampled normalized Kruskal's stress"),
        SAMMON("Sammnon's stress"),
        QUADRATIC_STRESS("Quadratic stress");

        private final String name;

        private StressType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

